/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.widgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.LibraryImage;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.tools.FontTools;

public class ImagePreview
extends Composite {
    private static final String[] HEADER_FONTS = new String[]{"Verdana", "DejaVu Sans", "Liberation Sans", "Arial"};
    private LibraryImage imageDescriptor;
    private Image image;
    private Label imageName;
    private Label imageSize;
    private Canvas imagePreview;
    private Font headerFont = FontTools.createFont((String[])HEADER_FONTS, (int)3, (int)1);

    public ImagePreview(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.getDisplay().getSystemColor(25));
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.imageName = new Label((Composite)this, 0);
        this.imageName.setBackground(this.getBackground());
        this.imageName.setText("No image selected");
        this.imageName.setFont(this.headerFont);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.imageName.setLayoutData((Object)gd);
        this.imageSize = new Label((Composite)this, 0);
        this.imageSize.setBackground(this.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.imageSize.setLayoutData((Object)gd);
        this.imagePreview = new Canvas((Composite)this, 0x20000000);
        this.imagePreview.setBackground(this.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.imagePreview.setLayoutData((Object)gd);
        this.imagePreview.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImagePreview.this.drawImagePreview(e.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImagePreview.this.headerFont.dispose();
                if (ImagePreview.this.image != null) {
                    ImagePreview.this.image.dispose();
                }
            }
        });
    }

    public void setImage(LibraryImage imageDescriptor) {
        if (imageDescriptor == null && this.imageDescriptor == null) {
            return;
        }
        this.imageDescriptor = imageDescriptor;
        this.imageName.setText(imageDescriptor != null ? imageDescriptor.getName() : "No image selected");
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = ImagePreview.createImageFromDescriptor(this.getDisplay(), imageDescriptor);
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            this.imageSize.setText(String.format("%d x %d", rect.width, rect.height));
        } else {
            this.imageSize.setText("");
        }
        this.imagePreview.redraw();
    }

    private void drawImagePreview(GC gc) {
        Rectangle rect = this.imagePreview.getClientArea();
        rect.width -= 2;
        rect.height -= 2;
        ++rect.x;
        ++rect.y;
        if (this.image == null) {
            if (rect.height > rect.width) {
                rect.height = rect.width;
            } else {
                rect.width = rect.height;
            }
            gc.drawRectangle(rect);
            gc.drawLine(0, 0, rect.width, rect.height);
            gc.drawLine(rect.width, 0, 0, rect.height);
        } else {
            Rectangle imageBounds = this.image.getBounds();
            if (imageBounds.width > rect.width || imageBounds.height > rect.height) {
                try {
                    gc.setAntialias(1);
                    gc.setInterpolation(2);
                }
                catch (SWTException sWTException) {
                    // empty catch block
                }
                float scaleFactorW = (float)imageBounds.width / (float)rect.width;
                float scaleFactorH = (float)imageBounds.height / (float)rect.height;
                float scaleFactor = Math.max(scaleFactorW, scaleFactorH);
                gc.drawImage(this.image, 0, 0, imageBounds.width, imageBounds.height, 0, 0, (int)((float)imageBounds.width / scaleFactor), (int)((float)imageBounds.height / scaleFactor));
            } else {
                gc.drawImage(this.image, 0, 0);
            }
        }
    }

    private static Image createImageFromDescriptor(Display display, LibraryImage imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        if (imageDescriptor.getBinaryData() != null) {
            try {
                return new Image((Device)display, (InputStream)new ByteArrayInputStream(imageDescriptor.getBinaryData()));
            }
            catch (Exception e) {
                Activator.logError("Cannot create image from library descriptor", e);
                return null;
            }
        }
        Image image = ImageProvider.getInstance().getImage(imageDescriptor.getGuid());
        return image != null ? new Image((Device)display, image, 0) : null;
    }
}

