/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.text.CompositeBox;
import org.eclipse.draw2d.text.FlowBox;

public abstract class LineBox
extends CompositeBox {
    int contentAscent;
    int contentDescent;
    List fragments = new ArrayList();

    @Override
    public void add(FlowBox child) {
        this.fragments.add(child);
        this.width += child.getWidth();
        this.contentAscent = Math.max(this.contentAscent, child.getOuterAscent());
        this.contentDescent = Math.max(this.contentDescent, child.getOuterDescent());
    }

    @Override
    public int getAscent() {
        int ascent = 0;
        int i = 0;
        while (i < this.fragments.size()) {
            ascent = Math.max(ascent, ((FlowBox)this.fragments.get(i)).getAscent());
            ++i;
        }
        return ascent;
    }

    int getAvailableWidth() {
        if (this.recommendedWidth < 0) {
            return Integer.MAX_VALUE;
        }
        return this.recommendedWidth - this.getWidth();
    }

    @Override
    int getBottomMargin() {
        return 0;
    }

    @Override
    public int getDescent() {
        int descent = 0;
        int i = 0;
        while (i < this.fragments.size()) {
            descent = Math.max(descent, ((FlowBox)this.fragments.get(i)).getDescent());
            ++i;
        }
        return descent;
    }

    List getFragments() {
        return this.fragments;
    }

    @Override
    int getTopMargin() {
        return 0;
    }

    public boolean isOccupied() {
        return !this.fragments.isEmpty();
    }

    @Override
    public boolean requiresBidi() {
        for (FlowBox box : this.getFragments()) {
            if (!box.requiresBidi()) continue;
            return true;
        }
        return false;
    }
}

