/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OUICache {
    private static Logger logger = LoggerFactory.getLogger(OUICache.class);
    private HashMap<MacAddress, String> ouiToVendorMap = new HashMap();
    private Set<MacAddress> syncList = new HashSet<MacAddress>();
    private List<Runnable> callbackList = new ArrayList<Runnable>();
    private BackgroundWorker backgroundWorker = new BackgroundWorker();
    private boolean running = true;
    private NXCSession session;

    public OUICache(NXCSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.running = false;
        try {
            Set<MacAddress> set = this.syncList;
            synchronized (set) {
                this.syncList.notifyAll();
            }
            this.backgroundWorker.join();
        }
        catch (InterruptedException e) {
            logger.debug("Unexpected error while joining background worker thread", e);
        }
        this.ouiToVendorMap.clear();
        this.syncList.clear();
        this.callbackList.clear();
        this.backgroundWorker = null;
        this.session = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVendor(MacAddress mac, Runnable callback) {
        if (mac == null || mac.isNull() || mac.getValue().length < 5) {
            return null;
        }
        String name = null;
        boolean needSync = false;
        Object object = this.ouiToVendorMap;
        synchronized (object) {
            int i;
            MacAddress macPart = new MacAddress(mac.getValue(), 3);
            name = this.ouiToVendorMap.get(macPart);
            if (name == null) {
                byte[] oui28 = new byte[4];
                for (i = 0; i < 4; ++i) {
                    oui28[i] = mac.getValue()[i];
                }
                oui28[3] = (byte)(oui28[3] & 0xF0);
                macPart = new MacAddress(oui28);
                name = this.ouiToVendorMap.get(macPart);
            }
            if (name == null) {
                byte[] oui32 = new byte[5];
                for (i = 0; i < 5; ++i) {
                    oui32[i] = mac.getValue()[i];
                }
                oui32[4] = (byte)(oui32[4] & 0xF0);
                macPart = new MacAddress(oui32);
                name = this.ouiToVendorMap.get(macPart);
            }
            if (name == null) {
                needSync = true;
            }
        }
        if (needSync) {
            object = this.syncList;
            synchronized (object) {
                this.syncList.add(mac);
                if (callback != null) {
                    this.callbackList.add(callback);
                }
                this.syncList.notifyAll();
            }
        }
        return name;
    }

    private class BackgroundWorker
    extends Thread {
        public BackgroundWorker() {
            this.setName("BackgroundOUISync");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (OUICache.this.running) {
                List callbackListCopy;
                Set syncListCopy;
                Set set = OUICache.this.syncList;
                synchronized (set) {
                    while (OUICache.this.running && OUICache.this.syncList.isEmpty()) {
                        try {
                            OUICache.this.syncList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!OUICache.this.running) break;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Set set2 = OUICache.this.syncList;
                synchronized (set2) {
                    syncListCopy = OUICache.this.syncList;
                    OUICache.this.syncList = new HashSet();
                    callbackListCopy = OUICache.this.callbackList;
                    OUICache.this.callbackList = new ArrayList();
                }
                try {
                    Map<MacAddress, String> updatedElements = OUICache.this.session.getVendorByMac(syncListCopy);
                    HashMap hashMap = OUICache.this.ouiToVendorMap;
                    synchronized (hashMap) {
                        OUICache.this.ouiToVendorMap.putAll(updatedElements);
                    }
                    for (Runnable cb : callbackListCopy) {
                        cb.run();
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while synchronizing OUI cache", e);
                }
            }
            logger.debug("OUI cache worker thread stopped");
        }
    }
}

