/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ColumnFilterSetOperation {
    AND(0),
    OR(1),
    UNKNOWN(2);

    private static Logger logger;
    private static Map<Integer, ColumnFilterSetOperation> lookupTable;
    private int value;

    private ColumnFilterSetOperation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ColumnFilterSetOperation getByValue(int value) {
        ColumnFilterSetOperation element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(ColumnFilterSetOperation.class);
        lookupTable = new HashMap<Integer, ColumnFilterSetOperation>();
        for (ColumnFilterSetOperation element : ColumnFilterSetOperation.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

