/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFormatter {
    private static final Logger logger = LoggerFactory.getLogger(DataFormatter.class);
    private String formatString;
    private DataType dataType;
    private MeasurementUnit unit;
    private static final double[] DECIMAL_MULTIPLIERS = new double[]{1.0, 1000.0, 1000000.0, 1.0E9, 1.0E12, 1.0E15};
    private static final double[] DECIMAL_MULTIPLIERS_SMALL = new double[]{1.0E-15, 1.0E-12, 1.0E-9, 1.0E-6, 0.001, 1.0};
    private static final double[] BINARY_MULTIPLIERS = new double[]{1.0, 1024.0, 1048576.0, 1.073741824E9, 1.099511627776E12, 1.125899906842624E15};
    private static final String[] SUFFIX = new String[]{"", "\u2009k", "\u2009M", "\u2009G", "\u2009T", "\u2009P"};
    private static final String[] BINARY_SUFFIX = new String[]{"", "\u2009Ki", "\u2009Mi", "\u2009Gi", "\u2009Ti", "\u2009Pi"};
    private static final String[] SUFFIX_SMALL = new String[]{"\u2009f", "\u2009p", "\u2009n", "\u2009\u03bc", "\u2009m", ""};

    public DataFormatter(String formatString, DataType dataType) {
        this.formatString = formatString;
        this.dataType = dataType;
        this.unit = null;
    }

    public DataFormatter(String formatString, DataType dataType, MeasurementUnit unit) {
        this.formatString = formatString;
        this.dataType = dataType;
        this.unit = unit;
        if (formatString == null || formatString.isEmpty()) {
            this.formatString = "%{m,u}s";
        }
    }

    public String format(String value, TimeFormatter formatter2) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] format = this.formatString.toCharArray();
        for (int i = 0; i < format.length; ++i) {
            if (format[i] == '%' && i + 1 != format.length) {
                int j;
                if (format[++i] == '%') {
                    sb.append('%');
                    continue;
                }
                boolean useMultipliers = false;
                boolean useUnits = false;
                if (format[i] == '*') {
                    useMultipliers = true;
                } else if (format[i] == '{' && i + 1 != format.length) {
                    int end;
                    for (end = i; end < format.length && format[end] != '}'; ++end) {
                    }
                    if (format[end] == '}' && end + 1 < format.length) {
                        if (i + 1 != end) {
                            String[] items;
                            for (String item : items = new String(Arrays.copyOfRange(format, i + 1, end)).split(",")) {
                                if (item.trim().compareToIgnoreCase("u") == 0 || item.trim().compareToIgnoreCase("units") == 0) {
                                    useUnits = this.unit != null;
                                    continue;
                                }
                                if (item.trim().compareToIgnoreCase("m") != 0 && item.trim().compareToIgnoreCase("multipliers") != 0) continue;
                                useMultipliers = true;
                            }
                        }
                        i = end + 1;
                    }
                }
                for (j = ++i; j < format.length && !Character.isLetter(format[j]); ++j) {
                }
                if (j + 1 < format.length && (format[j] == 't' || format[j] == 'T') && Character.isLetter(format[j + 1])) {
                    ++j;
                }
                String f = "%" + new String(Arrays.copyOfRange(format, i, j + 1));
                i = j;
                if (useUnits && this.unit.getName().equals("Uptime")) {
                    sb.append(formatter2.formatUptime((long)Double.parseDouble(value)));
                    continue;
                }
                if (useUnits && this.unit.getName().equals("Epoch time")) {
                    sb.append(formatter2.formatDateAndTime((long)Double.parseDouble(value)));
                    continue;
                }
                try {
                    Value v = this.getValueForFormat(value, useMultipliers, format[j]);
                    sb.append(String.format(f, v.value));
                    sb.append(v.suffix);
                    if (!useUnits) continue;
                    String unitName = this.unit.getName();
                    if (v.suffix.isEmpty() && !unitName.isEmpty()) {
                        sb.append("\u2009");
                    }
                    sb.append(unitName);
                }
                catch (IndexOutOfBoundsException | NumberFormatException | IllegalFormatException e) {
                    logger.debug("Error formatting value \"" + value + "\"", e);
                    sb.append("<INVALID FORMAT> (");
                    sb.append(f.trim());
                    sb.append(")");
                }
                continue;
            }
            sb.append(format[i]);
        }
        return sb.toString();
    }

    private Value getValueWithMultipliers(String value) {
        boolean isSmallNumber;
        double d;
        try {
            d = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return new Value(value);
        }
        boolean useBinaryMultipliers = this.unit != null && this.unit.isBinary();
        int multiplierPower = this.unit != null ? this.unit.getMultipierPower() : 0;
        boolean bl = isSmallNumber = d > -0.01 && d < 0.01 && d != 0.0 && multiplierPower <= 0 && this.unit != null && this.unit.useMultiplierForUnit() || multiplierPower < 0;
        double[] multipliers = isSmallNumber ? DECIMAL_MULTIPLIERS_SMALL : (useBinaryMultipliers ? BINARY_MULTIPLIERS : DECIMAL_MULTIPLIERS);
        int i = 0;
        if (multiplierPower != 0) {
            if (isSmallNumber) {
                multiplierPower = 5 + multiplierPower;
            }
            i = Integer.min(multiplierPower, multipliers.length - 1);
        } else if (this.unit == null || this.unit.useMultiplierForUnit()) {
            for (i = multipliers.length - 1; i >= 0 && !(d >= multipliers[i]) && !(d <= -multipliers[i]); --i) {
            }
        } else {
            multipliers = DECIMAL_MULTIPLIERS;
        }
        Value v = new Value();
        if (i >= 0) {
            v.value = d / multipliers[i];
            v.suffix = isSmallNumber ? SUFFIX_SMALL[i] : (useBinaryMultipliers ? BINARY_SUFFIX[i] : SUFFIX[i]);
        } else {
            v.value = value;
        }
        return v;
    }

    private Value getValueForFormat(String value, boolean useMultipliers, char formatSymbol) throws NumberFormatException {
        if (this.dataType == DataType.STRING || this.dataType == DataType.NULL) {
            return new Value(value);
        }
        Value v = useMultipliers ? this.getValueWithMultipliers(value) : new Value(value);
        switch (formatSymbol) {
            case 'S': 
            case 's': {
                if (!(v.value instanceof Double)) break;
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setMaximumFractionDigits(2);
                v.value = nf.format((Double)v.value);
                break;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                if (!(v.value instanceof String)) break;
                v.value = Double.parseDouble((String)v.value);
                break;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                if (v.value instanceof String) {
                    try {
                        v.value = Long.parseLong((String)v.value);
                    }
                    catch (NumberFormatException e) {
                        v.value = Double.valueOf(Double.parseDouble((String)v.value)).longValue();
                    }
                    break;
                }
                if (!(v.value instanceof Double)) break;
                v.value = ((Double)v.value).longValue();
                break;
            }
        }
        return v;
    }

    private static int calculatePrecision(double number) {
        int i = 0;
        if (number == 0.0 || number >= 1.0) {
            return i;
        }
        for (i = 1; i < 1000; ++i) {
            double d;
            number *= 10.0;
            if (d >= 1.0) break;
        }
        return i;
    }

    public static String roundDecimalValue(double value, double step, int maxPrecision) {
        int i;
        if (value == 0.0) {
            return "0";
        }
        double absValue = Math.abs(value);
        double[] multipliers = DECIMAL_MULTIPLIERS;
        for (i = multipliers.length - 1; i >= 0 && !(absValue >= multipliers[i]); --i) {
        }
        int precision = step < 1.0 || i < 0 ? (DataFormatter.calculatePrecision(step) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step)) : (DataFormatter.calculatePrecision(step / multipliers[i]) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step / multipliers[i]));
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        return df.format(i < 0 ? value : value / multipliers[i]) + (i < 0 ? "" : SUFFIX[i]);
    }

    private class Value {
        Object value;
        String suffix = "";

        Value() {
        }

        Value(Object value) {
            this.value = value;
        }
    }
}

