/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.datacollection.TableDciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.datacollection.TimeFormatter;

public abstract class DciValue {
    public static final int MULTIPLIERS_DEFAULT = 0;
    public static final int MULTIPLIERS_YES = 1;
    public static final int MULTIPLIERS_NO = 2;
    protected long id;
    protected long nodeId;
    protected long templateDciId;
    protected String name;
    protected String description;
    protected String value;
    protected String comments;
    protected DataOrigin source;
    protected DataType dataType;
    protected int status;
    protected int errorCount;
    protected int dcObjectType;
    protected Date timestamp;
    protected Threshold activeThreshold;
    protected int flags;
    protected MeasurementUnit measurementUnit;
    protected int multiplier;
    protected boolean noValueObject;
    protected boolean anomalyDetected;

    public static DciValue createFromMessage(NXCPMessage msg, long base2) {
        int type = msg.getFieldAsInt32(base2 + 10L);
        switch (type) {
            case 1: {
                return new SimpleDciValue(msg, base2);
            }
            case 2: {
                return new TableDciValue(msg, base2);
            }
        }
        return null;
    }

    protected DciValue() {
    }

    protected DciValue(NXCPMessage msg, long base2) {
        long fieldId = base2;
        this.nodeId = msg.getFieldAsInt64(fieldId++);
        this.id = msg.getFieldAsInt64(fieldId++);
        this.name = msg.getFieldAsString(fieldId++);
        this.flags = msg.getFieldAsInt32(fieldId++);
        this.description = msg.getFieldAsString(fieldId++);
        this.source = DataOrigin.getByValue(msg.getFieldAsInt32(fieldId++));
        this.dataType = DataType.getByValue(msg.getFieldAsInt32(fieldId++));
        this.value = msg.getFieldAsString(fieldId++);
        this.timestamp = msg.getFieldAsDate(fieldId++);
        this.status = msg.getFieldAsInt32(fieldId++);
        this.dcObjectType = msg.getFieldAsInt32(fieldId++);
        this.errorCount = msg.getFieldAsInt32(fieldId++);
        this.templateDciId = msg.getFieldAsInt64(fieldId++);
        this.measurementUnit = new MeasurementUnit(msg, fieldId++);
        this.multiplier = msg.getFieldAsInt32(fieldId++);
        this.noValueObject = msg.getFieldAsBoolean(fieldId++);
        this.comments = msg.getFieldAsString(fieldId++);
        this.anomalyDetected = msg.getFieldAsBoolean(fieldId++);
        this.activeThreshold = msg.getFieldAsBoolean(fieldId++) ? new Threshold(msg, fieldId) : null;
    }

    public String format(String formatString, TimeFormatter formatter2) {
        return new DataFormatter(formatString, this.dataType, this.measurementUnit).format(this.value, formatter2);
    }

    public String getFormattedValue(boolean useMultipliers, TimeFormatter formatter2) {
        int selection = this.getMultipliersSelection();
        String format = selection == 0 && useMultipliers || selection == 1 ? "%{m,u}s" : "%{u}s";
        return new DataFormatter(format, this.dataType, this.measurementUnit).format(this.value, formatter2);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name.isEmpty() ? "[" + this.getId() + "]" : this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public String getComments() {
        return this.comments;
    }

    public DataOrigin getSource() {
        return this.source;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getStatus() {
        return this.status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Threshold getActiveThreshold() {
        return this.activeThreshold;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public final long getTemplateDciId() {
        return this.templateDciId;
    }

    public Severity getThresholdSeverity() {
        return this.activeThreshold != null ? this.activeThreshold.getCurrentSeverity() : Severity.NORMAL;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getMultipliersSelection() {
        return (this.flags & 0x30000) >> 16;
    }

    public Severity getMostCriticalSeverity() {
        return this.getThresholdSeverity();
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public boolean isNoValueObject() {
        return this.noValueObject;
    }

    public boolean isAnomalyDetected() {
        return this.anomalyDetected;
    }

    public String toString() {
        return "DciValue [id=" + this.id + ", nodeId=" + this.nodeId + ", templateDciId=" + this.templateDciId + ", name=" + this.name + ", description=" + this.description + ", value=" + this.value + ", comments=" + this.comments + ", source=" + (Object)((Object)this.source) + ", dataType=" + (Object)((Object)this.dataType) + ", status=" + this.status + ", errorCount=" + this.errorCount + ", dcObjectType=" + this.dcObjectType + ", timestamp=" + this.timestamp + ", activeThreshold=" + this.activeThreshold + ", flags=" + this.flags + ", measurementUnit=" + this.measurementUnit + ", multiplier=" + this.multiplier + ", noValueObject=" + this.noValueObject + ", anomalyDetected=" + this.anomalyDetected + "]";
    }
}

