/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netxms.base.NXCPMessage;

public class MeasurementUnit {
    public static final MeasurementUnit BYTES_IEC = new MeasurementUnit("B (IEC)");
    public static final MeasurementUnit BYTES_METRIC = new MeasurementUnit("B");
    public static final MeasurementUnit BPS_IEC = new MeasurementUnit("bps (IEC)");
    public static final MeasurementUnit BPS_METRIC = new MeasurementUnit("bps");
    public static final MeasurementUnit HZ = new MeasurementUnit("Hz");
    public static final Set<String> UNITS_WITHOUT_MULTIPLIERS = new HashSet<String>(Arrays.asList("%", "\u00b0C", "\u00b0F", "dbm"));
    private String name;
    private boolean binary;
    private int multiplierPower;

    public MeasurementUnit(String name, int multiplierPower) {
        this.name = name.replace(" (IEC)", "").replace(" (Metric)", "");
        this.multiplierPower = multiplierPower;
        this.binary = name.contains(" (IEC)");
    }

    public MeasurementUnit(String name) {
        this(name, 0);
    }

    public MeasurementUnit(NXCPMessage msg, long baseId) {
        this(msg.getFieldAsString(baseId), msg.getFieldAsInt32(baseId + 1L));
    }

    public String getName() {
        return this.name;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public int getMultipierPower() {
        return this.multiplierPower;
    }

    public boolean useMultiplierForUnit() {
        return !UNITS_WITHOUT_MULTIPLIERS.contains(this.name);
    }

    public String toString() {
        return "MeasurementUnit [name=" + this.name + ", binary=" + this.binary + ", multiplierPower=" + this.multiplierPower + "]";
    }
}

