/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.xml.XMLTools;

public class NetworkMapDCIImage
extends NetworkMapElement {
    private DCIImageConfiguration config;

    protected NetworkMapDCIImage(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String xml2 = msg.getFieldAsString(baseId + 10L);
        try {
            this.config = XMLTools.createFromXml(DCIImageConfiguration.class, xml2);
        }
        catch (Exception e) {
            this.config = new DCIImageConfiguration();
        }
    }

    public NetworkMapDCIImage(long id) {
        super(id);
        this.type = 4;
        this.config = new DCIImageConfiguration();
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        try {
            msg.setField(baseId + 10L, this.config.createXml());
        }
        catch (Exception e) {
            msg.setField(baseId + 10L, "");
        }
    }

    public DCIImageConfiguration getImageOptions() {
        return this.config;
    }

    public void setImageOptions(DCIImageConfiguration imageOptions) {
        this.config = imageOptions;
    }
}

