/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.reporting;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.xml.XMLTools;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;

@Root(name="result", strict=false)
public class ReportResult {
    @Element(required=true)
    private UUID jobId;
    @Element(required=false)
    private UUID reportId;
    @Element(required=false)
    private Date executionTime;
    @Element(required=false)
    private int userId;
    @Element(required=false)
    private boolean success;

    public static ReportResult loadFromFile(File xmlFile) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        return (ReportResult)((Object)serializer.read(ReportResult.class, xmlFile, false));
    }

    protected ReportResult() {
        this.jobId = NXCommon.EMPTY_GUID;
        this.reportId = NXCommon.EMPTY_GUID;
        this.executionTime = new Date();
        this.userId = 0;
        this.success = false;
    }

    public ReportResult(UUID jobId, UUID reportId, Date executionTime, int userId, boolean success) {
        this.jobId = jobId;
        this.reportId = reportId;
        this.executionTime = executionTime;
        this.userId = userId;
        this.success = success;
    }

    public ReportResult(NXCPMessage msg, long baseId) {
        this.jobId = msg.getFieldAsUUID(baseId);
        this.reportId = msg.getFieldAsUUID(baseId + 1L);
        this.executionTime = msg.getFieldAsDate(baseId + 2L);
        this.userId = msg.getFieldAsInt32(baseId + 3L);
        this.success = msg.getFieldAsBoolean(baseId + 4L);
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setField(baseId, this.jobId);
        msg.setField(baseId + 1L, this.reportId);
        msg.setField(baseId + 2L, this.executionTime);
        msg.setFieldInt32(baseId + 3L, this.userId);
        msg.setField(baseId + 4L, this.success);
    }

    public String createXml() throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, writer);
        return ((Object)writer).toString();
    }

    public void saveAsXml(File file) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        FileWriter writer = new FileWriter(file);
        serializer.write((Object)this, writer);
        ((Writer)writer).close();
    }

    public UUID getJobId() {
        return this.jobId;
    }

    public UUID getReportId() {
        return this.reportId;
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    public int getUserId() {
        return this.userId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String toString() {
        return "ReportResult [jobId=" + this.jobId + ", executionTime=" + this.executionTime + ", userId=" + this.userId + ", success=" + this.success + "]";
    }
}

