/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.topology.OSPFArea;
import org.netxms.client.topology.OSPFNeighbor;

public class OSPFInfo {
    private InetAddress routerId;
    private OSPFArea[] areas;
    private OSPFNeighbor[] neighbors;

    public OSPFInfo(NXCPMessage msg) {
        this.routerId = msg.getFieldAsInetAddress(767L);
        int count2 = msg.getFieldAsInt32(799L);
        this.areas = new OSPFArea[count2];
        long fieldId = 0x20000000L;
        int i = 0;
        while (i < count2) {
            this.areas[i] = new OSPFArea(msg, fieldId);
            ++i;
            fieldId += 10L;
        }
        count2 = msg.getFieldAsInt32(800L);
        this.neighbors = new OSPFNeighbor[count2];
        fieldId = 0x30000000L;
        i = 0;
        while (i < count2) {
            this.neighbors[i] = new OSPFNeighbor(msg, fieldId);
            ++i;
            fieldId += 10L;
        }
    }

    public InetAddress getRouterId() {
        return this.routerId;
    }

    public OSPFArea[] getAreas() {
        return this.areas;
    }

    public OSPFNeighbor[] getNeighbors() {
        return this.neighbors;
    }
}

