/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.base.annotations.Internal;
import org.netxms.client.constants.RadioBand;
import org.netxms.client.objects.AbstractObject;

public class RadioInterface {
    @Internal
    private AbstractObject owner;
    private int index;
    private String name;
    private MacAddress bssid;
    private String ssid;
    private int frequency;
    private RadioBand band;
    private int channel;
    private int powerDBm;
    private int powerMW;

    public RadioInterface(AbstractObject owner, NXCPMessage msg, long baseId) {
        this.owner = owner;
        this.index = msg.getFieldAsInt32(baseId);
        this.name = msg.getFieldAsString(baseId + 1L);
        this.bssid = new MacAddress(msg.getFieldAsBinary(baseId + 2L));
        this.frequency = msg.getFieldAsInt32(baseId + 3L);
        this.band = RadioBand.getByValue(msg.getFieldAsInt32(baseId + 4L));
        this.channel = msg.getFieldAsInt32(baseId + 5L);
        this.powerDBm = msg.getFieldAsInt32(baseId + 6L);
        this.powerMW = msg.getFieldAsInt32(baseId + 7L);
        this.ssid = msg.getFieldAsString(baseId + 8L);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public MacAddress getBSSID() {
        return this.bssid;
    }

    public String getSSID() {
        return this.ssid;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public RadioBand getBand() {
        return this.band;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getPowerDBm() {
        return this.powerDBm;
    }

    public int getPowerMW() {
        return this.powerMW;
    }

    public AbstractObject getOwner() {
        return this.owner;
    }
}

