/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1.x509;

import java.io.IOException;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.DERGeneralizedTime;
import org.python.bouncycastle.asn1.DERIA5String;
import org.python.bouncycastle.asn1.DERPrintableString;
import org.python.bouncycastle.asn1.DERUTF8String;
import org.python.bouncycastle.asn1.x500.style.BCStyle;
import org.python.bouncycastle.asn1.x509.X509NameEntryConverter;

public class X509DefaultEntryConverter
extends X509NameEntryConverter {
    @Override
    public ASN1Primitive getConvertedValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        if (string2.length() != 0 && string2.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(string2, 1);
            }
            catch (IOException iOException) {
                throw new RuntimeException("can't recode value for oid " + aSN1ObjectIdentifier.getId());
            }
        }
        if (string2.length() != 0 && string2.charAt(0) == '\\') {
            string2 = string2.substring(1);
        }
        if (aSN1ObjectIdentifier.equals(BCStyle.EmailAddress) || aSN1ObjectIdentifier.equals(BCStyle.DC)) {
            return new DERIA5String(string2);
        }
        if (aSN1ObjectIdentifier.equals(BCStyle.DATE_OF_BIRTH)) {
            return new DERGeneralizedTime(string2);
        }
        if (aSN1ObjectIdentifier.equals(BCStyle.C) || aSN1ObjectIdentifier.equals(BCStyle.SERIALNUMBER) || aSN1ObjectIdentifier.equals(BCStyle.DN_QUALIFIER) || aSN1ObjectIdentifier.equals(BCStyle.TELEPHONE_NUMBER)) {
            return new DERPrintableString(string2);
        }
        return new DERUTF8String(string2);
    }
}

