/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class InetAddressListElement {
    public static final int SUBNET = 0;
    public static final int RANGE = 1;
    private int type;
    private InetAddress baseAddress;
    private InetAddress endAddress;
    private int maskBits;
    private int zoneUIN;
    private long proxyId;
    private String comment;

    public InetAddressListElement(InetAddress baseAddress, InetAddress endAddress, int zoneUIN, long proxyId, String comment) {
        this.type = 1;
        this.baseAddress = baseAddress;
        this.endAddress = endAddress;
        this.maskBits = 0;
        this.zoneUIN = zoneUIN;
        this.proxyId = proxyId;
        this.comment = comment;
    }

    public InetAddressListElement(InetAddress baseAddress, int maskBits, int zoneUIN, long proxyId, String comment) {
        this.type = 0;
        this.baseAddress = baseAddress;
        this.endAddress = null;
        this.maskBits = maskBits;
        this.zoneUIN = zoneUIN;
        this.proxyId = proxyId;
        this.comment = comment;
    }

    public void update(InetAddress baseAddress, InetAddress endAddress, int zoneUIN, long proxyId, String comment) {
        this.type = 1;
        this.baseAddress = baseAddress;
        this.endAddress = endAddress;
        this.maskBits = 0;
        this.zoneUIN = zoneUIN;
        this.proxyId = proxyId;
        this.comment = comment;
    }

    public void update(InetAddress baseAddress, int maskBits, int zoneUIN, long proxyId, String comment) {
        this.type = 0;
        this.baseAddress = baseAddress;
        this.endAddress = null;
        this.maskBits = maskBits;
        this.zoneUIN = zoneUIN;
        this.proxyId = proxyId;
        this.comment = comment;
    }

    protected InetAddressListElement(NXCPMessage msg, long baseId) {
        this.type = msg.getFieldAsInt32(baseId);
        this.baseAddress = msg.getFieldAsInetAddress(baseId + 1L);
        if (this.type == 0) {
            this.maskBits = msg.getFieldAsInt32(baseId + 2L);
            this.endAddress = null;
        } else {
            this.endAddress = msg.getFieldAsInetAddress(baseId + 2L);
            this.maskBits = 0;
        }
        this.zoneUIN = msg.getFieldAsInt32(baseId + 3L);
        this.proxyId = msg.getFieldAsInt64(baseId + 4L);
        this.comment = msg.getFieldAsString(baseId + 5L);
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt16(baseId, this.type);
        msg.setField(baseId + 1L, this.baseAddress);
        if (this.type == 0) {
            msg.setFieldInt16(baseId + 2L, this.maskBits);
        } else {
            msg.setField(baseId + 2L, this.endAddress);
        }
        msg.setFieldInt32(baseId + 3L, this.zoneUIN);
        msg.setFieldInt32(baseId + 4L, (int)this.proxyId);
        msg.setField(baseId + 5L, this.comment);
    }

    public int getType() {
        return this.type;
    }

    public InetAddress getBaseAddress() {
        return this.baseAddress;
    }

    public InetAddress getEndAddress() {
        return this.endAddress;
    }

    public int getMaskBits() {
        return this.maskBits;
    }

    public int getZoneUIN() {
        return this.zoneUIN;
    }

    public long getProxyId() {
        return this.proxyId;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "InetAddressListElement [type=" + this.type + ", baseAddress=" + this.baseAddress + ", endAddress=" + this.endAddress + ", maskBits=" + this.maskBits + ", zoneUIN=" + this.zoneUIN + ", proxyId=" + this.proxyId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.baseAddress == null ? 0 : this.baseAddress.hashCode());
        result2 = 31 * result2 + (this.endAddress == null ? 0 : this.endAddress.hashCode());
        result2 = 31 * result2 + this.maskBits;
        result2 = 31 * result2 + (int)(this.proxyId ^ this.proxyId >>> 32);
        result2 = 31 * result2 + this.type;
        result2 = 31 * result2 + (this.zoneUIN ^ this.zoneUIN >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressListElement other = (InetAddressListElement)obj;
        if (this.baseAddress == null ? other.baseAddress != null : !this.baseAddress.equals(other.baseAddress)) {
            return false;
        }
        if (this.endAddress == null ? other.endAddress != null : !this.endAddress.equals(other.endAddress)) {
            return false;
        }
        if (this.maskBits != other.maskBits) {
            return false;
        }
        if (this.proxyId != other.proxyId) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.zoneUIN == other.zoneUIN;
    }

    public boolean isSubnet() {
        return this.type == 0;
    }
}

