/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.NXCPMessage;

public class MapDCIInstance {
    private long dciID;
    private long nodeID;
    private int type;
    private String column;
    private String instance;
    private Map<Long, Long> mapObjectIdList = new HashMap<Long, Long>();

    public MapDCIInstance(long dciID, long nodeID, String column, String instance, int type, long mapObjectId) {
        this.setDciID(dciID);
        this.setNodeID(nodeID);
        this.setColumn(column);
        this.setInstance(instance);
        this.type = type;
        this.mapObjectIdList.put(mapObjectId, 1L);
    }

    public MapDCIInstance(long dciID, long nodeID, int type, long mapObjectId) {
        this.setDciID(dciID);
        this.setNodeID(nodeID);
        this.setColumn("");
        this.setInstance("");
        this.type = type;
        this.mapObjectIdList.put(mapObjectId, 1L);
    }

    public void addMap(long mapId) {
        if (this.mapObjectIdList.containsKey(mapId)) {
            this.mapObjectIdList.put(mapId, this.mapObjectIdList.get(mapId) + 1L);
        } else {
            this.mapObjectIdList.put(mapId, 1L);
        }
    }

    public boolean removeMap(long mapId) {
        if (this.mapObjectIdList.containsKey(mapId)) {
            this.mapObjectIdList.put(mapId, this.mapObjectIdList.get(mapId) - 1L);
            if (this.mapObjectIdList.get(mapId) == 0L) {
                this.mapObjectIdList.remove(mapId);
            }
        }
        return this.mapObjectIdList.size() == 0;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public long getDciID() {
        return this.dciID;
    }

    public void setDciID(long dciID) {
        this.dciID = dciID;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(long nodeID) {
        this.nodeID = nodeID;
    }

    public void fillMessage(NXCPMessage msg, long base2) {
        if (this.type == 2 && (this.column.isEmpty() || this.instance.isEmpty())) {
            return;
        }
        msg.setFieldInt32(base2++, (int)this.nodeID);
        msg.setFieldInt32(base2++, (int)this.dciID);
        msg.setFieldInt32(base2++, this.mapObjectIdList.entrySet().iterator().next().getKey().intValue());
        if (this.type == 2) {
            msg.setField(base2++, this.column);
            msg.setField(base2++, this.instance);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.column == null || this.type == 2 ? 0 : this.column.hashCode());
        result2 = 31 * result2 + (int)(this.dciID ^ this.dciID >>> 32);
        result2 = 31 * result2 + (this.instance == null || this.type == 2 ? 0 : this.instance.hashCode());
        result2 = 31 * result2 + (int)(this.nodeID ^ this.nodeID >>> 32);
        result2 = 31 * result2 + this.type;
        return result2;
    }

    public boolean equals(Object object) {
        boolean result2;
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MapDCIInstance)) {
            return false;
        }
        MapDCIInstance i = (MapDCIInstance)object;
        if (i.type != this.type) {
            return false;
        }
        boolean bl = result2 = i.dciID == this.dciID;
        if (result2 && i.type == 2) {
            result2 = i.column.equals(this.column) && i.instance.equals(this.instance);
        }
        return result2;
    }
}

