/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.netxms.client.ClientLocalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SensorDeviceClass {
    OTHER(0),
    UPS(1),
    WATER_METER(2),
    ELECTRICITY_METER(3),
    TEMPERATURE_SENSOR(4),
    HUMIDITY_SENSOR(5),
    TEMPERATURE_HUMIDITY_SENSOR(6),
    CO2_SENSOR(7),
    POWER_SUPPLY(8),
    CURRENT_SENSOR(9),
    WATER_LEAK_DETECTOR(10),
    SMOKE_DETECTOR(11);

    private static Logger logger;
    private static Map<Integer, SensorDeviceClass> lookupTable;
    private int value;

    private SensorDeviceClass(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getDisplayName() {
        String name = this.toString();
        return ClientLocalizationHelper.getText("SensorDeviceClass_" + name, Locale.getDefault(), name);
    }

    public String getDisplayName(Locale locale2) {
        String name = this.toString();
        return ClientLocalizationHelper.getText("SensorDeviceClass_" + name, locale2, name);
    }

    public static SensorDeviceClass getByValue(int value) {
        SensorDeviceClass element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return OTHER;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(SensorDeviceClass.class);
        lookupTable = new HashMap<Integer, SensorDeviceClass>();
        for (SensorDeviceClass element : SensorDeviceClass.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

