/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.regex.Matcher;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.interfaces.NodeItemPair;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dci", strict=false)
public class ChartDciConfig
implements NodeItemPair {
    public static final String UNSET_COLOR = "UNSET";
    public static final int ITEM = 1;
    public static final int TABLE = 2;
    public static final int DEFAULT = -1;
    public static final int LINE = 0;
    public static final int AREA = 1;
    private static final int UNSET = -99;
    @Attribute
    public long nodeId;
    @Attribute
    public long dciId;
    @Element(required=false)
    public String dciName;
    @Element(required=false)
    public String dciDescription;
    @Element(required=false)
    public int type;
    @Element(required=false)
    public String color;
    @Element(required=false)
    public String name;
    @Element(required=false)
    public int lineWidth;
    @Element(required=false)
    public int lineChartType;
    @Element(required=false)
    protected int displayType;
    @Element(required=false)
    public boolean showThresholds;
    @Element(required=false)
    public boolean invertValues;
    @Element(required=false)
    public boolean useRawValues;
    @Element(required=false)
    public boolean multiMatch;
    @Element(required=false)
    public boolean regexMatch;
    @Element(required=false)
    public String instance;
    @Element(required=false)
    public String column;
    @Element(required=false)
    public String displayFormat;

    public ChartDciConfig() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.dciName = "";
        this.dciDescription = "";
        this.type = 1;
        this.color = UNSET_COLOR;
        this.name = "";
        this.lineWidth = 2;
        this.lineChartType = -1;
        this.displayType = -99;
        this.showThresholds = false;
        this.invertValues = false;
        this.multiMatch = false;
        this.regexMatch = true;
        this.instance = "";
        this.column = "";
        this.displayFormat = "";
    }

    public ChartDciConfig(ChartDciConfig src) {
        this.nodeId = src.nodeId;
        this.dciId = src.dciId;
        this.dciName = src.dciName;
        this.dciDescription = src.dciDescription;
        this.type = src.type;
        this.color = src.color;
        this.name = src.name;
        this.lineWidth = src.lineWidth;
        this.lineChartType = src.lineChartType;
        this.displayType = src.displayType;
        this.showThresholds = src.showThresholds;
        this.invertValues = src.invertValues;
        this.useRawValues = src.useRawValues;
        this.multiMatch = src.multiMatch;
        this.regexMatch = src.regexMatch;
        this.instance = src.instance;
        this.column = src.column;
        this.displayFormat = src.displayFormat;
    }

    public ChartDciConfig(DciValue dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.dciName = dci.getName();
        this.dciDescription = dci.getDescription();
        this.type = dci.getDcObjectType();
        this.name = "";
        this.color = UNSET_COLOR;
        this.lineWidth = 2;
        this.lineChartType = -1;
        this.displayType = -99;
        this.showThresholds = false;
        this.invertValues = false;
        this.multiMatch = false;
        this.regexMatch = false;
        this.instance = "";
        this.column = "";
        this.displayFormat = "";
    }

    public ChartDciConfig(ChartDciConfig src, DciValue dciValue) {
        this.nodeId = dciValue.getNodeId();
        this.dciId = dciValue.getId();
        this.dciName = dciValue.getName();
        this.dciDescription = dciValue.getDescription();
        this.type = dciValue.getDcObjectType();
        this.color = src.color;
        this.lineWidth = src.lineWidth;
        this.lineChartType = src.lineChartType;
        this.displayType = src.displayType;
        this.showThresholds = src.showThresholds;
        this.invertValues = src.invertValues;
        this.useRawValues = src.useRawValues;
        this.multiMatch = src.multiMatch;
        this.regexMatch = src.regexMatch;
        this.instance = src.instance;
        this.column = src.column;
        this.displayFormat = src.displayFormat;
        this.name = src.name.isEmpty() ? dciValue.getDescription() : src.name;
    }

    public ChartDciConfig(ChartDciConfig src, Matcher matcher, DciValue dciValue) {
        this.nodeId = dciValue.getNodeId();
        this.dciId = dciValue.getId();
        this.dciName = dciValue.getName();
        this.dciDescription = dciValue.getDescription();
        this.type = dciValue.getDcObjectType();
        this.color = src.color;
        this.lineWidth = src.lineWidth;
        this.lineChartType = src.lineChartType;
        this.displayType = src.displayType;
        this.showThresholds = src.showThresholds;
        this.invertValues = src.invertValues;
        this.useRawValues = src.useRawValues;
        this.multiMatch = src.multiMatch;
        this.regexMatch = src.regexMatch;
        this.instance = src.instance;
        this.column = src.column;
        this.displayFormat = src.displayFormat;
        if (src.name.isEmpty()) {
            this.name = dciValue.getDescription();
        } else {
            StringBuilder sb = new StringBuilder();
            int state = 0;
            block4: for (char c : src.name.toCharArray()) {
                switch (state) {
                    case 0: {
                        if (c == '\\') {
                            state = 1;
                            continue block4;
                        }
                        sb.append(c);
                        continue block4;
                    }
                    case 1: {
                        if (c == '\\') {
                            sb.append(c);
                        } else if (c >= '0' && c <= '9') {
                            int group = '\u0000' + c - 48;
                            if (matcher.groupCount() >= group) {
                                sb.append(matcher.group(group));
                            }
                        } else {
                            sb.append('\\');
                            sb.append(c);
                        }
                        state = 0;
                    }
                }
            }
            this.name = sb.toString();
        }
    }

    public ChartDciConfig(DataCollectionObject dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.dciName = dci.getName();
        this.dciDescription = dci.getDescription();
        this.type = dci instanceof DataCollectionItem ? 1 : 2;
        this.name = dci.getDescription();
        this.color = UNSET_COLOR;
        this.lineWidth = 2;
        this.lineChartType = -1;
        this.displayType = -99;
        this.showThresholds = false;
        this.invertValues = false;
        this.useRawValues = false;
        this.multiMatch = false;
        this.regexMatch = false;
        this.instance = "";
        this.column = "";
        this.displayFormat = "";
    }

    public ChartDciConfig(GraphItem item) {
        this.nodeId = item.getNodeId();
        this.dciId = item.getDciId();
        this.dciName = item.getName();
        this.dciDescription = item.getDescription();
        this.type = item.getType();
        this.name = "";
        this.color = item.getColor() == -1 ? UNSET_COLOR : "0x" + Integer.toHexString(item.getColor());
        this.lineWidth = item.getLineWidth();
        this.lineChartType = item.getLineChartType();
        this.displayType = -99;
        this.showThresholds = item.isShowThresholds();
        this.invertValues = item.isInverted();
        this.multiMatch = false;
        this.regexMatch = false;
        this.instance = item.getInstance();
        this.column = item.getDataColumn();
        this.displayFormat = item.getDisplayFormat();
    }

    public int getColorAsInt() {
        if (this.color.equals(UNSET_COLOR)) {
            return -1;
        }
        if (this.color.startsWith("0x")) {
            return Integer.parseInt(this.color.substring(2), 16);
        }
        return Integer.parseInt(this.color, 10);
    }

    public void setColor(int value) {
        this.color = "0x" + Integer.toHexString(value);
    }

    public String getLabel() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.dciDescription != null && !this.dciDescription.isEmpty()) {
            return this.dciDescription;
        }
        if (this.dciName != null && !this.dciName.isEmpty()) {
            return this.dciName;
        }
        return "[" + Long.toString(this.dciId) + "]";
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public int getLineChartType() {
        return this.displayType != -99 ? this.displayType - 1 : this.lineChartType;
    }

    public String getDciName() {
        return this.dciName == null ? "" : this.dciName;
    }

    public void setDciName(String dciName) {
        this.dciName = dciName;
    }

    public String getDciDescription() {
        return this.dciDescription == null ? "" : this.dciDescription;
    }

    public void setDciDescription(String dciDescription) {
        this.dciDescription = dciDescription;
    }

    public String toString() {
        return "ChartDciConfig [nodeId=" + this.nodeId + ", dciId=" + this.dciId + ", dciName=" + this.dciName + ", dciDescription=" + this.dciDescription + ", type=" + this.type + ", color=" + this.color + ", name=" + this.name + ", lineWidth=" + this.lineWidth + ", lineChartType=" + this.lineChartType + ", displayType=" + this.displayType + ", showThresholds=" + this.showThresholds + ", invertValues=" + this.invertValues + ", useRawValues=" + this.useRawValues + ", multiMatch=" + this.multiMatch + ", useRegex=" + this.regexMatch + ", instance=" + this.instance + ", column=" + this.column + ", displayFormat=" + this.displayFormat + "]";
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public long getDciId() {
        return this.dciId;
    }
}

