/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.reporting;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCException;
import org.netxms.client.ScheduledTask;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.client.reporting.ReportRenderFormat;
import org.netxms.client.reporting.ReportingJobConfiguration;
import org.netxms.client.xml.XMLTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingJob {
    private static final Logger logger = LoggerFactory.getLogger(ReportingJob.class);
    private ReportingJobConfiguration configuration;
    private ScheduledTask task;

    public ReportingJob(ReportDefinition report) {
        this.configuration = new ReportingJobConfiguration(report.getId());
        this.task = new ScheduledTask();
        this.task.setTaskHandlerId("Report.Execute");
        this.task.setComments(report.getName());
    }

    public ReportingJob(NXCPMessage msg, long baseId) {
        this.task = new ScheduledTask(msg, baseId);
        try {
            this.configuration = XMLTools.createFromXml(ReportingJobConfiguration.class, this.task.getParameters());
        }
        catch (Exception e) {
            logger.error("Cannot deserialize reporting job parameters", e);
            this.configuration = new ReportingJobConfiguration(NXCommon.EMPTY_GUID);
        }
    }

    public void fillMessage(NXCPMessage msg) throws NXCException {
        try {
            this.task.setParameters(this.configuration.createXml());
            this.task.fillMessage(msg);
        }
        catch (Exception e) {
            throw new NXCException(46, (Throwable)e);
        }
    }

    public ReportRenderFormat getRenderFormat() {
        return this.configuration.renderFormat;
    }

    public void setRenderFormat(ReportRenderFormat renderFormat) {
        this.configuration.renderFormat = renderFormat;
    }

    public List<String> getEmailRecipients() {
        return this.configuration.emailRecipients;
    }

    public void setEmailRecipients(List<String> emailRecipients) {
        this.configuration.emailRecipients = emailRecipients;
    }

    public UUID getReportId() {
        return this.configuration.reportId;
    }

    public boolean isNotifyOnCompletion() {
        return this.configuration.notifyOnCompletion;
    }

    public void setNotifyOnCompletion(boolean notifyOnCompletion) {
        this.configuration.notifyOnCompletion = notifyOnCompletion;
    }

    public Map<String, String> getExecutionParameters() {
        return this.configuration.executionParameters;
    }

    public String getExecutionParameter(String name) {
        return this.configuration.executionParameters.get(name);
    }

    public void setExecutionParameter(String name, String value) {
        this.configuration.executionParameters.put(name, value);
    }

    public ScheduledTask prepareTask() throws Exception {
        this.task.setParameters(this.configuration.createXml());
        return this.task;
    }

    public ScheduledTask getTask() {
        return this.task;
    }
}

