/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.users;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.CertificateMappingMethod;
import org.netxms.client.constants.UserAuthenticationMethod;
import org.netxms.client.users.AbstractUserObject;

public class User
extends AbstractUserObject {
    private UserAuthenticationMethod authMethod;
    private CertificateMappingMethod certMappingMethod;
    private String certMappingData;
    private String fullName;
    private Date lastLogin = null;
    private Date lastPasswordChange = null;
    private int minPasswordLength;
    private Date disabledUntil = null;
    private int authFailures;
    private String email;
    private String phoneNumber;
    private int[] groups;
    private Map<String, Map<String, String>> twoFactorAuthMethodBindings;

    public User(String name) {
        super(name, "user");
        this.fullName = "";
        this.email = "";
        this.phoneNumber = "";
        this.groups = new int[0];
        this.twoFactorAuthMethodBindings = new HashMap<String, Map<String, String>>(0);
    }

    public User(User src) {
        super(src);
        this.authMethod = src.authMethod;
        this.certMappingMethod = src.certMappingMethod;
        this.certMappingData = src.certMappingData;
        this.fullName = src.fullName;
        this.lastLogin = src.lastLogin;
        this.lastPasswordChange = src.lastPasswordChange;
        this.minPasswordLength = src.minPasswordLength;
        this.disabledUntil = src.disabledUntil;
        this.authFailures = src.authFailures;
        this.email = src.email;
        this.phoneNumber = src.phoneNumber;
        this.groups = Arrays.copyOf(src.groups, src.groups.length);
        this.twoFactorAuthMethodBindings = new HashMap<String, Map<String, String>>(src.twoFactorAuthMethodBindings.size());
        for (Map.Entry<String, Map<String, String>> e : src.twoFactorAuthMethodBindings.entrySet()) {
            this.twoFactorAuthMethodBindings.put(e.getKey(), new HashMap<String, String>(e.getValue()));
        }
    }

    public User(NXCPMessage msg) {
        super(msg, "user");
        this.authMethod = UserAuthenticationMethod.getByValue(msg.getFieldAsInt32(16L));
        this.fullName = msg.getFieldAsString(40L);
        this.certMappingMethod = CertificateMappingMethod.getByValue(msg.getFieldAsInt32(279L));
        this.certMappingData = msg.getFieldAsString(280L);
        this.lastLogin = msg.getFieldAsDate(351L);
        this.lastPasswordChange = msg.getFieldAsDate(352L);
        this.minPasswordLength = msg.getFieldAsInt32(350L);
        this.disabledUntil = msg.getFieldAsDate(353L);
        this.authFailures = msg.getFieldAsInt32(354L);
        this.email = msg.getFieldAsString(728L);
        this.phoneNumber = msg.getFieldAsString(729L);
        this.groups = msg.getFieldAsInt32Array(462L);
        if (this.groups == null) {
            this.groups = new int[0];
        }
        int count2 = msg.getFieldAsInt32(751L);
        this.twoFactorAuthMethodBindings = new HashMap<String, Map<String, String>>(count2);
        long fieldId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            String name = msg.getFieldAsString(fieldId);
            this.twoFactorAuthMethodBindings.put(name, msg.getStringMapFromFields(fieldId + 10L, fieldId + 9L));
            fieldId += 1000L;
        }
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setFieldInt16(16L, this.authMethod.getValue());
        msg.setField(40L, this.fullName);
        msg.setFieldInt16(279L, this.certMappingMethod.getValue());
        msg.setField(280L, this.certMappingData);
        msg.setFieldInt16(350L, this.minPasswordLength);
        msg.setFieldInt32(353L, this.disabledUntil != null ? (int)(this.disabledUntil.getTime() / 1000L) : 0);
        msg.setField(728L, this.email);
        msg.setField(729L, this.phoneNumber);
        msg.setFieldInt32(284L, this.groups.length);
        if (this.groups.length > 0) {
            msg.setField(462L, this.groups);
        }
        msg.setFieldInt32(751L, this.twoFactorAuthMethodBindings.size());
        long fieldId = 0x10000000L;
        for (Map.Entry<String, Map<String, String>> e : this.twoFactorAuthMethodBindings.entrySet()) {
            msg.setField(fieldId, e.getKey());
            msg.setFieldsFromStringMap(e.getValue(), fieldId + 10L, fieldId + 9L);
            fieldId += 1000L;
        }
    }

    public UserAuthenticationMethod getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(UserAuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public CertificateMappingMethod getCertMappingMethod() {
        return this.certMappingMethod;
    }

    public void setCertMappingMethod(CertificateMappingMethod certMappingMethod) {
        this.certMappingMethod = certMappingMethod;
    }

    public String getCertMappingData() {
        return this.certMappingData;
    }

    public void setCertMappingData(String certMappingData) {
        this.certMappingData = certMappingData;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String getLabel() {
        if (this.fullName.isEmpty()) {
            return super.getLabel();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(" <");
        sb.append(this.fullName);
        if (!this.description.isEmpty()) {
            sb.append("> (");
            sb.append(this.description);
            sb.append(')');
        } else {
            sb.append('>');
        }
        return sb.toString();
    }

    public int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    public void setMinPasswordLength(int minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
    }

    public Date getDisabledUntil() {
        return this.disabledUntil;
    }

    public void setDisabledUntil(Date disabledUntil) {
        this.disabledUntil = disabledUntil;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public Date getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    public int getAuthFailures() {
        return this.authFailures;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public int[] getGroups() {
        return this.groups;
    }

    public void setGroups(int[] groups) {
        this.groups = groups;
    }

    public Map<String, Map<String, String>> getTwoFactorAuthMethodBindings() {
        return this.twoFactorAuthMethodBindings;
    }

    public void setTwoFactorAuthMethodBindings(Map<String, Map<String, String>> twoFactorAuthMethodBindings) {
        this.twoFactorAuthMethodBindings = twoFactorAuthMethodBindings;
    }
}

