/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cert.cmp;

import java.math.BigInteger;
import org.python.bouncycastle.asn1.ASN1Object;
import org.python.bouncycastle.asn1.cmp.CMPCertificate;
import org.python.bouncycastle.asn1.cmp.CertStatus;
import org.python.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.cert.X509CertificateHolder;
import org.python.bouncycastle.cert.cmp.CMPException;
import org.python.bouncycastle.cert.cmp.CMPUtil;
import org.python.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.python.bouncycastle.operator.DigestCalculatorProvider;
import org.python.bouncycastle.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        return this.isVerified(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), digestCalculatorProvider);
    }

    public boolean isVerified(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        byte[] byArray = CMPUtil.calculateCertHash((ASN1Object)cMPCertificate, algorithmIdentifier, digestCalculatorProvider, this.digestAlgFinder);
        return Arrays.constantTimeAreEqual(this.certStatus.getCertHash().getOctets(), byArray);
    }
}

