/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.json.JsonTools;
import org.netxms.websvc.json.ResponseContainer;

public class FindMacAddress
extends AbstractHandler {
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        session.syncObjects();
        MacAddress macAddress = MacAddress.parseMacAddress((String)query.get("macAddress"), (boolean)false);
        int searchLimit = 100;
        String limit = query.get("searchLimit");
        if (limit != null) {
            searchLimit = Integer.parseInt(limit);
        }
        boolean includeObjects = Boolean.parseBoolean(query.getOrDefault("includeObjects", "false"));
        List cpList = session.findConnectionPoints(macAddress.getValue(), searchLimit);
        ArrayList<JsonObject> searchResults = new ArrayList<JsonObject>();
        Gson gson = JsonTools.createGsonInstance();
        for (ConnectionPoint cp : cpList) {
            JsonObject json = (JsonObject)gson.toJsonTree((Object)cp);
            if (includeObjects) {
                AbstractObject object = session.findObjectById(cp.getNodeId());
                if (object != null) {
                    json.add("node", gson.toJsonTree((Object)object));
                    if (session.isZoningEnabled() && object instanceof Node) {
                        json.addProperty("nodesZoneUIN", (Number)((Node)object).getZoneId());
                        json.addProperty("nodesZoneName", ((Node)object).getZoneName());
                    }
                }
                if ((object = session.findObjectById(cp.getInterfaceId())) != null) {
                    json.add("interface", gson.toJsonTree((Object)object));
                }
                if ((object = session.findObjectById(cp.getLocalNodeId())) != null) {
                    json.add("localNode", gson.toJsonTree((Object)object));
                    if (session.isZoningEnabled() && object instanceof Node) {
                        json.addProperty("localNodeZoneUIN", (Number)((Node)object).getZoneId());
                        json.addProperty("localNodeZoneName", ((Node)object).getZoneName());
                    }
                }
                if ((object = session.findObjectById(cp.getLocalInterfaceId())) != null) {
                    json.add("localInterface", gson.toJsonTree((Object)object));
                }
            }
            searchResults.add(json);
        }
        return new ResponseContainer("searchResults", searchResults);
    }
}

