/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actionmanager.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.ServerAction;
import org.netxms.ui.eclipse.actionmanager.dialogs.helpers.ActionSelectionDialogLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ActionSelectionDialog
extends Dialog {
    private TableViewer viewer;
    private List<ServerAction> selection;

    public ActionSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ActionSelectionDialogLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ServerAction)e1).getName().compareToIgnoreCase(((ServerAction)e2).getName());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ActionSelectionDialog.this.okPressed();
            }
        });
        new ConsoleJob("Get server actions", null, "org.netxms.ui.eclipse.actionmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = ConsoleSharedData.getSession().getActions();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ActionSelectionDialog.this.viewer.setInput((Object)list.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get server actions";
            }
        }.start();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        gd.minimumWidth = 500;
        this.viewer.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.selection = this.viewer.getStructuredSelection().toList();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select action");
    }

    public List<ServerAction> getSelection() {
        return this.selection;
    }
}

