/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.WirelessStation;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class WirelessStationComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        WirelessStation ws1 = (WirelessStation)e1;
        WirelessStation ws2 = (WirelessStation)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = ws1.getMacAddress().compareTo(ws2.getMacAddress());
                break;
            }
            case 1: {
                result = this.getVendor(ws1).compareToIgnoreCase(this.getVendor(ws2));
                break;
            }
            case 2: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)ws1.getIpAddress(), (InetAddress)ws2.getIpAddress());
                break;
            }
            case 3: {
                result = this.session.getObjectName(ws1.getNodeObjectId()).compareToIgnoreCase(this.session.getObjectName(ws2.getNodeObjectId()));
                break;
            }
            case 4: {
                result = this.session.getObjectName(ws1.getAccessPointId()).compareToIgnoreCase(this.session.getObjectName(ws2.getAccessPointId()));
                break;
            }
            case 6: {
                result = ws1.getSsid().compareToIgnoreCase(ws2.getSsid());
                break;
            }
            case 5: {
                result = ws1.getRadioInterface().compareToIgnoreCase(ws2.getRadioInterface());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendor(WirelessStation ws) {
        String vendor = this.session.getVendorByMac(ws.getMacAddress(), null);
        return vendor != null ? vendor : "";
    }
}

