/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.MessageBar;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ProcessesTab
extends ObjectTab {
    public static final int COLUMN_PID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_USER = 2;
    public static final int COLUMN_THREADS = 3;
    public static final int COLUMN_HANDLES = 4;
    public static final int COLUMN_VMSIZE = 5;
    public static final int COLUMN_RSS = 6;
    public static final int COLUMN_PAGE_FAULTS = 7;
    public static final int COLUMN_KTIME = 8;
    public static final int COLUMN_UTIME = 9;
    public static final int COLUMN_CMDLINE = 10;
    private CompositeWithMessageBar viewerContainer;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private Action actionTerminate;
    private boolean showFilter;
    private String filterString = null;

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Node && ((Node)object).hasAgent();
    }

    @Override
    protected void createTabContent(Composite parent) {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.showFilter = ProcessesTab.getBooleanFromSettings(settings, "ProcessesTab.showFilter", true);
        this.viewerContainer = new CompositeWithMessageBar(parent, 0){

            protected Composite createContent(Composite parent) {
                Composite content = super.createContent(parent);
                content.setLayout((Layout)new FormLayout());
                return content;
            }
        };
        this.filterText = new FilterText(this.viewerContainer.getContent(), 0, null, true);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProcessesTab.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ProcessesTab.this.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
                State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        });
        String[] names = new String[]{"PID", "Name", "User", "Threads", "Handles", "VM Size", "RSS", "Page faults", "System time", "User time", "Command line"};
        int[] widths = new int[]{90, 200, 140, 90, 90, 90, 90, 90, 90, 90, 500};
        this.viewer = new SortableTableViewer(this.viewerContainer.getContent(), names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProcessLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ProcessComparator());
        this.viewer.addFilter((ViewerFilter)new ProcessFilter());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ProcessTable.V2");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)ProcessesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ProcessTable.V2");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("ProcessesTab.showFilter", ProcessesTab.this.showFilter);
            }
        });
        if (this.showFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionTerminate = new Action("&Terminate"){

            public void run() {
                ProcessesTab.this.terminateProcess();
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager(String.valueOf(this.getViewPart().getSite().getId()) + ".ProcessesTab");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProcessesTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionTerminate);
    }

    @Override
    public void selected() {
        super.selected();
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
        State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
        state.setValue((Object)this.showFilter);
        service.refreshElements(command.getId(), null);
        this.refresh();
    }

    @Override
    public void objectChanged(AbstractObject object) {
        if (this.isActive()) {
            this.refresh();
        } else {
            this.viewer.setInput((Object)new Object[0]);
        }
    }

    @Override
    public void refresh() {
        final long nodeId = this.getObject().getObjectId();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get process list", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.objectview", (MessageBar)this.viewerContainer){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                org.netxms.client.Table processTable = session.queryTable(nodeId, DataOrigin.AGENT, "System.Processes");
                int[] indexes = new int[]{processTable.getColumnIndex("PID"), processTable.getColumnIndex("NAME"), processTable.getColumnIndex("USER"), processTable.getColumnIndex("THREADS"), processTable.getColumnIndex("HANDLES"), processTable.getColumnIndex("VMSIZE"), processTable.getColumnIndex("RSS"), processTable.getColumnIndex("PAGE_FAULTS"), processTable.getColumnIndex("KTIME"), processTable.getColumnIndex("UTIME"), processTable.getColumnIndex("CMDLINE")};
                final Process[] processes = new Process[processTable.getRowCount()];
                int i = 0;
                while (i < processTable.getRowCount()) {
                    TableRow r = processTable.getRow(i);
                    Process process = new Process();
                    int j = 0;
                    while (j < indexes.length) {
                        process.data[j] = r.getValueAsLong(indexes[j]);
                        ++j;
                    }
                    process.name = indexes[1] != -1 ? r.getValue(indexes[1]) : "";
                    process.user = indexes[2] != -1 ? r.getValue(indexes[2]) : "";
                    process.commandLine = indexes[10] != -1 ? r.getValue(indexes[10]) : "";
                    processes[i] = process;
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ProcessesTab.this.viewer.getControl().isDisposed()) {
                            (this).ProcessesTab.this.viewer.setInput((Object)processes);
                        }
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ProcessesTab.this.viewer.setInput((Object)new Object[0]);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get process list";
            }
        }.start();
    }

    private void terminateProcess() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getViewPart().getSite().getShell(), (String)"Terminate Process", (String)"Selected processes will be terminated. Are you sure?")) {
            return;
        }
        final ArrayList<Long> processes = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            processes.add(((Process)o).data[0]);
        }
        final long nodeId = this.getObject().getObjectId();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Terminate process", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.objectview"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Long pid : processes) {
                    session.executeAction(nodeId, "Process.Terminate", new String[]{Long.toString(pid)});
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ProcessesTab.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot execute command on remote system";
            }
        }.start();
    }

    public void enableFilter(boolean enable) {
        this.showFilter = enable;
        this.filterText.setVisible(this.showFilter);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.viewerContainer.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    private void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text;
        this.filterString = text = this.filterText.getText();
        this.viewer.refresh(false);
    }

    private static boolean getBooleanFromSettings(IDialogSettings settings, String name, boolean defaultValue) {
        if (settings.get(name) == null) {
            return defaultValue;
        }
        return settings.getBoolean(name);
    }

    private static class Process {
        long[] data = new long[11];
        String name;
        String commandLine;
        String user;

        private Process() {
        }
    }

    private static class ProcessComparator
    extends ViewerComparator {
        private ProcessComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result;
            int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
            switch (column) {
                case 10: {
                    result = ((Process)e1).commandLine.compareToIgnoreCase(((Process)e2).commandLine);
                    break;
                }
                case 1: {
                    result = ((Process)e1).name.compareToIgnoreCase(((Process)e2).name);
                    break;
                }
                case 2: {
                    result = ((Process)e1).user.compareToIgnoreCase(((Process)e2).user);
                    break;
                }
                default: {
                    result = Long.signum(((Process)e1).data[column] - ((Process)e2).data[column]);
                }
            }
            return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
        }
    }

    private class ProcessFilter
    extends ViewerFilter {
        private ProcessFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (ProcessesTab.this.filterString == null || ProcessesTab.this.filterString.isEmpty()) {
                return true;
            }
            Process process = (Process)element;
            return process.name.toLowerCase().contains(ProcessesTab.this.filterString) || process.commandLine.toLowerCase().contains(ProcessesTab.this.filterString) || process.user.toLowerCase().contains(ProcessesTab.this.filterString);
        }
    }

    private static class ProcessLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProcessLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 10: {
                    return ((Process)element).commandLine;
                }
                case 1: {
                    return ((Process)element).name;
                }
                case 2: {
                    return ((Process)element).user;
                }
            }
            return Long.toString(((Process)element).data[columnIndex]);
        }
    }
}

