/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.netxms.client.maps.NetworkMapLink;

public class MultiLabelConnectionLocator
extends ConnectionLocator {
    private NetworkMapLink link;

    public MultiLabelConnectionLocator(Connection connection, NetworkMapLink link) {
        super(connection);
        this.link = link;
    }

    protected Point getLocation(PointList points) {
        double y;
        double x;
        double adj = Math.abs(points.getLastPoint().preciseX() - points.getFirstPoint().preciseX());
        double opp = Math.abs(points.getLastPoint().preciseY() - points.getFirstPoint().preciseY());
        double theta = Math.atan(opp / adj);
        double length = Math.sqrt(Math.pow(adj, 2.0) + Math.pow(opp, 2.0));
        double dividedLength = length / (double)(this.link.getDuplicateCount() + 2) * (double)(this.link.getPosition() + 1);
        if (points.getFirstPoint().preciseX() > points.getLastPoint().preciseX() && points.getFirstPoint().preciseY() > points.getLastPoint().preciseY() || points.getFirstPoint().preciseX() > points.getLastPoint().preciseX() && points.getFirstPoint().preciseY() == points.getLastPoint().preciseY()) {
            x = points.getLastPoint().preciseX() + dividedLength * Math.cos(theta);
            y = points.getLastPoint().preciseY() + dividedLength * Math.sin(theta);
        } else if (points.getFirstPoint().preciseX() > points.getLastPoint().preciseX() && points.getFirstPoint().preciseY() < points.getLastPoint().preciseY() || points.getFirstPoint().preciseX() == points.getLastPoint().preciseX() && points.getFirstPoint().preciseY() < points.getLastPoint().preciseY()) {
            x = points.getFirstPoint().preciseX() - (length - dividedLength) * Math.cos(-theta);
            y = points.getFirstPoint().preciseY() - (length - dividedLength) * Math.sin(-theta);
        } else if (points.getFirstPoint().preciseX() < points.getLastPoint().preciseX() && points.getFirstPoint().preciseY() > points.getLastPoint().preciseY()) {
            x = points.getLastPoint().preciseX() - (length - dividedLength) * Math.cos(-theta);
            y = points.getLastPoint().preciseY() - (length - dividedLength) * Math.sin(-theta);
        } else if (points.getFirstPoint().preciseX() == points.getLastPoint().preciseX() && points.getFirstPoint().preciseY() > points.getLastPoint().preciseY()) {
            x = points.getLastPoint().preciseX() + (length - dividedLength) * Math.cos(theta);
            y = points.getLastPoint().preciseY() + (length - dividedLength) * Math.sin(theta);
        } else {
            x = points.getFirstPoint().preciseX() + dividedLength * Math.cos(theta);
            y = points.getFirstPoint().preciseY() + dividedLength * Math.sin(theta);
        }
        return new Point(x, y);
    }
}

