/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.log.ColumnFilter;
import org.netxms.ui.eclipse.console.resources.SharedIcons;

public abstract class ConditionEditor
extends Composite {
    private Runnable deleteHandler;
    private Label logicalOperation;
    private Combo operation;

    protected ConditionEditor(Composite parent) {
        super(parent, 0);
        this.setBackground(parent.getBackground());
    }

    public void initialize(ColumnFilter initialFilter) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.setLayout((Layout)layout);
        this.logicalOperation = new Label((Composite)this, 0);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 0x1000000;
        gd.widthHint = 30;
        this.logicalOperation.setLayoutData((Object)gd);
        this.operation = new Combo((Composite)this, 8);
        String[] stringArray = this.getOperations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.operation.add(s);
            ++n2;
        }
        this.operation.select(0);
        this.operation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionEditor.this.operationSelectionChanged(ConditionEditor.this.operation.getSelectionIndex());
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.operation.setLayoutData((Object)gd);
        this.createContent(initialFilter);
        ImageHyperlink link = new ImageHyperlink((Composite)this, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setBackground(this.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ConditionEditor.this.dispose();
                ConditionEditor.this.deleteHandler.run();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        link.setLayoutData((Object)gd);
        this.layout(true, true);
    }

    protected void operationSelectionChanged(int selectionIndex) {
    }

    protected abstract String[] getOperations();

    protected abstract void createContent(ColumnFilter var1);

    public abstract ColumnFilter createFilter();

    public void setLogicalOperation(String name) {
        this.logicalOperation.setText(name);
    }

    public void setDeleteHandler(Runnable deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    protected int getSelectedOperation() {
        return this.operation.getSelectionIndex();
    }

    protected void setSelectedOperation(int op) {
        this.operation.select(op);
    }
}

