/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;

public class ObjectToolsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] TOOL_TYPES;
    private Image[] toolTypeImages = new Image[TOOL_TYPES.length + 1];

    static {
        String[] stringArray = new String[11];
        Messages.get();
        stringArray[0] = Messages.ObjectToolsLabelProvider_TypeInternal;
        Messages.get();
        stringArray[1] = Messages.ObjectToolsLabelProvider_TypeAgentCmd;
        Messages.get();
        stringArray[2] = Messages.ObjectToolsLabelProvider_TypeSNMPTable;
        Messages.get();
        stringArray[3] = Messages.ObjectToolsLabelProvider_TypeAgentList;
        Messages.get();
        stringArray[4] = Messages.ObjectToolsLabelProvider_TypeURL;
        Messages.get();
        stringArray[5] = Messages.ObjectToolsLabelProvider_TypeLocalCmd;
        Messages.get();
        stringArray[6] = Messages.ObjectToolsLabelProvider_TypeServerCmd;
        Messages.get();
        stringArray[7] = Messages.ObjectToolsLabelProvider_TypeDownloadFile;
        Messages.get();
        stringArray[8] = Messages.ObjectToolsLabelProvider_TypeServerScript;
        Messages.get();
        stringArray[9] = Messages.ObjectToolsLabelProvider_TypeAgentTable;
        Messages.get();
        stringArray[10] = Messages.ObjectToolsLabelProvider_TypeSshCmd;
        TOOL_TYPES = stringArray;
    }

    public ObjectToolsLabelProvider() {
        this.toolTypeImages[0] = Activator.getImageDescriptor("icons/internal_tool.gif").createImage();
        this.toolTypeImages[1] = Activator.getImageDescriptor("icons/agent_action.gif").createImage();
        this.toolTypeImages[2] = Activator.getImageDescriptor("icons/table.gif").createImage();
        this.toolTypeImages[3] = Activator.getImageDescriptor("icons/table.gif").createImage();
        this.toolTypeImages[4] = Activator.getImageDescriptor("icons/url.gif").createImage();
        this.toolTypeImages[5] = Activator.getImageDescriptor("icons/console.png").createImage();
        this.toolTypeImages[6] = Activator.getImageDescriptor("icons/console.png").createImage();
        this.toolTypeImages[7] = Activator.getImageDescriptor("icons/file_download.png").createImage();
        this.toolTypeImages[8] = Activator.getImageDescriptor("icons/script.png").createImage();
        this.toolTypeImages[9] = Activator.getImageDescriptor("icons/table.gif").createImage();
        this.toolTypeImages[10] = Activator.getImageDescriptor("icons/console.png").createImage();
        this.toolTypeImages[11] = Activator.getImageDescriptor("icons/stop.png").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        try {
            if ((((ObjectTool)element).getFlags() & 4) == 0) {
                return this.toolTypeImages[((ObjectTool)element).getToolType()];
            }
            return this.toolTypeImages[this.toolTypeImages.length - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        ObjectTool tool = (ObjectTool)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(tool.getId());
            }
            case 1: {
                return tool.getName();
            }
            case 2: {
                try {
                    return TOOL_TYPES[tool.getToolType()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return "<unknown>";
                }
            }
            case 3: {
                return tool.getDescription();
            }
        }
        return null;
    }

    public void dispose() {
        Image[] imageArray = this.toolTypeImages;
        int n = this.toolTypeImages.length;
        int n2 = 0;
        while (n2 < n) {
            Image i = imageArray[n2];
            i.dispose();
            ++n2;
        }
        super.dispose();
    }

    public static String getToolTypeName(ObjectTool tool) {
        try {
            return TOOL_TYPES[tool.getToolType()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "<unknown>";
        }
    }

    public static String[] getAllToolTypes() {
        return TOOL_TYPES;
    }
}

