/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RadioInterfaceComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        RadioInterface rif1 = (RadioInterface)e1;
        RadioInterface rif2 = (RadioInterface)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 1: {
                result = ((AccessPoint)rif1.getOwner()).getMacAddress().compareTo(((AccessPoint)rif2.getOwner()).getMacAddress());
                break;
            }
            case 3: {
                result = ((AccessPoint)rif1.getOwner()).getModel().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getModel());
                break;
            }
            case 0: {
                result = ((AccessPoint)rif1.getOwner()).getObjectName().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getObjectName());
                break;
            }
            case 4: {
                result = ((AccessPoint)rif1.getOwner()).getSerialNumber().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getSerialNumber());
                break;
            }
            case 2: {
                result = ((AccessPoint)rif1.getOwner()).getVendor().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getVendor());
                break;
            }
            case 9: {
                result = rif1.getChannel() - rif2.getChannel();
                break;
            }
            case 5: {
                result = rif1.getIndex() - rif2.getIndex();
                break;
            }
            case 7: {
                result = rif1.getBSSID().compareTo(rif2.getBSSID());
                break;
            }
            case 8: {
                result = this.getVendorByMAC(rif1.getBSSID()).compareToIgnoreCase(this.getVendorByMAC(rif2.getBSSID()));
                break;
            }
            case 6: {
                result = rif1.getName().compareToIgnoreCase(rif2.getName());
                break;
            }
            case 10: {
                result = rif1.getPowerDBm() - rif2.getPowerDBm();
                break;
            }
            case 11: {
                result = rif1.getPowerMW() - rif2.getPowerMW();
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendorByMAC(MacAddress macAddr) {
        String vendor = this.session.getVendorByMac(macAddr, null);
        return vendor != null ? vendor : "";
    }
}

