/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.api.ConsoleTweaklet;

public class TweakletManager {
    private static Set<ConsoleTweaklet> tweaklets = new HashSet<ConsoleTweaklet>();

    static void initTweaklets() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.tweaklets");
        int i = 0;
        while (i < elements.length) {
            try {
                ConsoleTweaklet t = (ConsoleTweaklet)elements[i].createExecutableExtension("class");
                tweaklets.add(t);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void postLogin(NXCSession session) {
        for (ConsoleTweaklet t : tweaklets) {
            t.postLogin(session);
        }
    }

    static void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
        for (ConsoleTweaklet t : tweaklets) {
            t.preWindowOpen(configurer);
        }
    }

    static void postWindowCreate(IWorkbenchWindowConfigurer configurer) {
        for (ConsoleTweaklet t : tweaklets) {
            t.postWindowCreate(configurer);
        }
    }
}

