/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.SpanningTreePortState;
import org.netxms.client.maps.MapType;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.Zone;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class GeneralInfo
extends TableElement {
    private static final String[] ifaceExpectedState;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.InterfaceListLabelProvider_StateUp;
        Messages.get();
        stringArray[1] = Messages.InterfaceListLabelProvider_StateDown;
        Messages.get();
        stringArray[2] = Messages.InterfaceListLabelProvider_StateIgnore;
        Messages.get();
        stringArray[3] = Messages.GeneralInfo_Auto;
        ifaceExpectedState = stringArray;
    }

    public GeneralInfo(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected void fillTable() {
        AbstractObject object = this.getObject();
        NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        this.addPair(Messages.GeneralInfo_ID, Long.toString(object.getObjectId()));
        if (object.getGuid() != null) {
            Messages.get();
            this.addPair(Messages.GeneralInfo_GUID, object.getGuid().toString());
        }
        Messages.get();
        this.addPair(Messages.GeneralInfo_Class, object.getObjectClassName());
        Messages.get();
        this.addPair(Messages.GeneralInfo_Alias, object.getAlias(), false);
        if (object.isInMaintenanceMode()) {
            Messages.get();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus())));
            Messages.get();
            this.addPair(Messages.GeneralInfo_Status, stringBuilder.append(Messages.GeneralInfo_Maintenance).toString());
            AbstractUserObject user = session.findUserDBObjectById(object.getMaintenanceInitiatorId(), new Runnable(){

                @Override
                public void run() {
                    GeneralInfo.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GeneralInfo.this.onObjectChange();
                        }
                    });
                }
            });
            this.addPair("Maintenance initiator", user != null ? user.getName() : "[" + object.getMaintenanceInitiatorId() + "]");
        } else {
            Messages.get();
            this.addPair(Messages.GeneralInfo_Status, StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        }
        if (object instanceof AbstractNode && (((AbstractNode)object).getCapabilities() & 0x800000L) != 0L) {
            this.addPair("Device state", ((AbstractNode)object).getCipStateText(), false);
            this.addPair("Device status", ((AbstractNode)object).getCipStatusText(), false);
            if ((((AbstractNode)object).getCipStatus() >> 4 & 0xF) != 0) {
                this.addPair("Extended device status", ((AbstractNode)object).getCipExtendedStatusText(), false);
            }
        }
        if (object.getCreationTime() != null && object.getCreationTime().getTime() != 0L) {
            this.addPair("Creation time", RegionalSettings.getDateTimeFormat().format(object.getCreationTime()), false);
        }
        switch (object.getObjectClass()) {
            case 35: {
                Rack rack;
                AbstractNode node;
                Chassis chassis = (Chassis)object;
                if (chassis.getControllerId() != 0L && (node = (AbstractNode)session.findObjectById(chassis.getControllerId(), AbstractNode.class)) != null) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_Controller, node.getObjectName());
                }
                if (chassis.getPhysicalContainerId() == 0L || (rack = (Rack)session.findObjectById(chassis.getPhysicalContainerId(), Rack.class)) == null) break;
                Messages.get();
                Messages.get();
                this.addPair(Messages.GeneralInfo_Rack, String.format(Messages.GeneralInfo_Units, rack.getObjectName(), rack.isTopBottomNumbering() ? chassis.getRackPosition() : chassis.getRackPosition() - chassis.getRackHeight() + 1, rack.isTopBottomNumbering() ? chassis.getRackPosition() + chassis.getRackHeight() - 1 : chassis.getRackPosition()));
                break;
            }
            case 3: {
                Interface iface = (Interface)object;
                Interface parentIface = iface.getParentInterface();
                if (parentIface != null) {
                    this.addPair("Parent interface", parentIface.getObjectName());
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_IfIndex, Integer.toString(iface.getIfIndex()));
                String typeName = iface.getIfTypeName();
                Messages.get();
                this.addPair(Messages.GeneralInfo_IfType, typeName != null ? String.format("%d (%s)", iface.getIfType(), typeName) : Integer.toString(iface.getIfType()));
                Messages.get();
                this.addPair(Messages.GeneralInfo_Description, iface.getDescription(), false);
                this.addPair("Interface alias", iface.getIfAlias(), false);
                if (iface.getMtu() > 0) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_MTU, Integer.toString(iface.getMtu()));
                }
                if (iface.getSpeed() > 0L) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_Speed, InterfaceListLabelProvider.ifSpeedTotext(iface.getSpeed()));
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_MACAddr, iface.getMacAddress().toString());
                String vendor = session.getVendorByMac(iface.getMacAddress(), null);
                if (vendor != null && !vendor.isEmpty()) {
                    this.addPair("MAC Address Vendor", vendor);
                }
                if (iface.isPhysicalPort()) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_SlotPort, iface.getPhysicalLocation());
                    AbstractNode node = iface.getParentNode();
                    if (node != null) {
                        if (node.isBridge() && iface.getStpPortState() != SpanningTreePortState.UNKNOWN) {
                            this.addPair("Spanning Tree port state", iface.getStpPortState().getText());
                        }
                        if (node.is8021xSupported()) {
                            Messages.get();
                            this.addPair(Messages.GeneralInfo_8021xPAE, iface.getDot1xPaeStateAsText());
                            Messages.get();
                            this.addPair(Messages.GeneralInfo_8021xBackend, iface.getDot1xBackendStateAsText());
                        }
                    }
                }
                this.addPair("VLAN", InterfaceListLabelProvider.getVlanList(iface), false);
                if (iface.getIpAddressList().size() > 0) {
                    if (session.isZoningEnabled()) {
                        Messages.get();
                        this.addPair(Messages.GeneralInfo_ZoneId, this.getZoneName(iface.getZoneId()));
                    }
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_IPAddr, ((InetAddressEx)iface.getIpAddressList().get(0)).toString());
                    int i = 1;
                    while (i < iface.getIpAddressList().size()) {
                        this.addPair("", ((InetAddressEx)iface.getIpAddressList().get(i)).toString());
                        ++i;
                    }
                }
                if (iface.isOSPF()) {
                    this.addPair("OSPF area", iface.getOSPFArea().getHostAddress());
                    this.addPair("OSPF interface type", iface.getOSPFType().getText(), false);
                    this.addPair("OSPF interface state", iface.getOSPFState().getText(), false);
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_AdmState, iface.getAdminStateAsText());
                Messages.get();
                this.addPair(Messages.GeneralInfo_OperState, iface.getOperStateAsText());
                Messages.get();
                this.addPair(Messages.GeneralInfo_ExpectedState, ifaceExpectedState[iface.getExpectedState()]);
                break;
            }
            case 2: {
                Rack rack;
                AbstractNode node = (AbstractNode)object;
                if (session.isZoningEnabled()) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_ZoneId, this.getZoneName(node.getZoneId()));
                }
                if ((node.getFlags() & 0x10000) != 0) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_PrimaryHostName, String.valueOf(node.getPrimaryName()) + " (external gateway)");
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_PrimaryIP, String.valueOf(node.getPrimaryIP().getHostAddress()) + " (external gateway)");
                } else {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_PrimaryHostName, node.getPrimaryName());
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_PrimaryIP, node.getPrimaryIP().getHostAddress());
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_NodeType, node.getNodeType().toString(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_HypervisorType, node.getHypervisorType(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_HypervisorInformation, node.getHypervisorInformation(), false);
                Messages.get();
                this.addPair(Messages.SensorStatus_Vendor, node.getHardwareVendor(), false);
                if ((node.getCapabilities() & 0x800000L) != 0L) {
                    this.addPair("Device type", node.getCipDeviceTypeName(), false);
                }
                this.addPair("Product name", node.getHardwareProductName(), false);
                this.addPair("Product code", node.getHardwareProductCode(), false);
                this.addPair("Product version", node.getHardwareProductVersion(), false);
                Messages.get();
                this.addPair(Messages.SensorStatus_SerialNumber, node.getHardwareSerialNumber(), false);
                if (node.hasAgent()) {
                    this.addPair("Hardware ID", node.getHardwareIdAsText(), false);
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_AgentVersion, node.getAgentVersion());
                    if (node.getAgentId() != null) {
                        Messages.get();
                        this.addPair(Messages.GeneralInfo_AgentId, node.getAgentId().toString());
                    }
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_SysDescr, node.getSystemDescription(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_PlatformName, node.getPlatformName(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_SysName, node.getSnmpSysName(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_SysOID, node.getSnmpOID(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_SNMPsysLocation, node.getSnmpSysLocation(), false);
                Messages.get();
                this.addPair(Messages.GeneralInfo_SNMPsysContact, node.getSnmpSysContact(), false);
                if (node.isBridge()) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_BridgeBaseAddress, node.getBridgeBaseAddress().toString());
                }
                if (node.isOSPF()) {
                    this.addPair("OSPF router ID", node.getOSPFRouterId().getHostAddress());
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_Driver, node.getDriverName(), false);
                if (node.getBootTime() != null) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_BootTime, RegionalSettings.getDateTimeFormat().format(node.getBootTime()), false);
                }
                if (node.hasAgent()) {
                    String string;
                    Messages.get();
                    if ((node.getStateFlags() & 0x10000) != 0) {
                        Messages.get();
                        string = Messages.GeneralInfo_Unreachable;
                    } else {
                        Messages.get();
                        string = Messages.GeneralInfo_Connected;
                    }
                    this.addPair(Messages.GeneralInfo_AgentStatus, string);
                }
                if (node.getLastAgentCommTime() != null) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_LastAgentContact, RegionalSettings.getDateTimeFormat().format(node.getLastAgentCommTime()), false);
                }
                if (node.getPhysicalContainerId() != 0L && (rack = (Rack)session.findObjectById(node.getPhysicalContainerId(), Rack.class)) != null) {
                    Messages.get();
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_Rack, String.format(Messages.GeneralInfo_Units, rack.getObjectName(), rack.isTopBottomNumbering() ? node.getRackPosition() : node.getRackPosition() - node.getRackHeight() + 1, rack.isTopBottomNumbering() ? node.getRackPosition() + node.getRackHeight() - 1 : node.getRackPosition()));
                }
                if (!node.isIcmpStatisticsCollected()) break;
                this.addPair("ICMP average response time", String.valueOf(node.getIcmpAverageResponseTime()) + " ms");
                this.addPair("ICMP packet loss", String.valueOf(node.getIcmpPacketLoss()) + "%");
                break;
            }
            case 31: {
                MobileDevice md = (MobileDevice)object;
                if (md.getLastReportTime().getTime() == 0L) {
                    Messages.get();
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_LastReport, Messages.GeneralInfo_Never);
                } else {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_LastReport, RegionalSettings.getDateTimeFormat().format(md.getLastReportTime()));
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_DeviceId, md.getDeviceId());
                this.addPair("Communication protocol", md.getCommProtocol());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Vendor, md.getVendor());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Model, md.getModel());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Serial, md.getSerialNumber());
                Messages.get();
                this.addPair(Messages.GeneralInfo_OS, md.getOsName());
                Messages.get();
                this.addPair(Messages.GeneralInfo_OSVersion, md.getOsVersion());
                Messages.get();
                this.addPair(Messages.GeneralInfo_User, md.getUserId(), false);
                if (md.getBatteryLevel() < 0) break;
                Messages.get();
                this.addPair(Messages.GeneralInfo_BatteryLevel, String.valueOf(Integer.toString(md.getBatteryLevel())) + "%");
                break;
            }
            case 37: {
                Sensor sensor = (Sensor)object;
                Messages.get();
                this.addPair(Messages.SensorStatus_DeviceAddress, sensor.getDeviceAddress(), false);
                if (sensor.getMacAddress() != null && !sensor.getMacAddress().isNull()) {
                    Messages.get();
                    this.addPair(Messages.SensorStatus_MacAddress, sensor.getMacAddress().toString(), true);
                    String vendorMac = session.getVendorByMac(sensor.getMacAddress(), null);
                    if (vendorMac != null && !vendorMac.isEmpty()) {
                        this.addPair("MAC Address Vendor", vendorMac);
                    }
                }
                Messages.get();
                this.addPair(Messages.SensorStatus_Vendor, sensor.getVendor(), true);
                Messages.get();
                this.addPair(Messages.SensorStatus_DeviceClass, sensor.getDeviceClass().getDisplayName());
                Messages.get();
                this.addPair(Messages.SensorStatus_SerialNumber, sensor.getSerialNumber(), true);
                break;
            }
            case 33: {
                AccessPoint ap = (AccessPoint)object;
                Messages.get();
                this.addPair(Messages.GeneralInfo_State, ap.getState().toString());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Vendor, ap.getVendor());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Model, ap.getModel());
                Messages.get();
                this.addPair(Messages.GeneralInfo_Serial, ap.getSerialNumber());
                Messages.get();
                this.addPair(Messages.GeneralInfo_MACAddr, ap.getMacAddress().toString());
                String vendorMac = session.getVendorByMac(ap.getMacAddress(), null);
                if (vendorMac != null && !vendorMac.isEmpty()) {
                    this.addPair("MAC Address Vendor", vendorMac);
                }
                if (!ap.getIpAddress().isValidAddress()) break;
                Messages.get();
                this.addPair(Messages.GeneralInfo_IPAddr, ap.getIpAddress().getHostAddress());
                break;
            }
            case 1: {
                Subnet subnet = (Subnet)object;
                if (session.isZoningEnabled()) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_ZoneId, this.getZoneName(subnet.getZoneId()));
                }
                Messages.get();
                this.addPair(Messages.GeneralInfo_IPAddress, subnet.getNetworkAddress().toString());
                break;
            }
            case 8: {
                Template template = (Template)object;
                this.addPair("Number of DCIs", Integer.toString(template.getNumDataCollectionItems()));
                this.addPair("Number of policies", Integer.toString(template.getNumPolicies()));
                break;
            }
            case 6: {
                Zone zone = (Zone)object;
                Messages.get();
                this.addPair(Messages.GeneralInfo_ZoneId, Long.toString(zone.getUIN()));
                break;
            }
            case 28: {
                BusinessService businessService = (BusinessService)object;
                this.addPair("Service state", businessService.getServiceState().toString());
                break;
            }
            case 14: {
                Cluster cluster = (Cluster)object;
                if (!session.isZoningEnabled()) break;
                this.addPair("Zone UIN", this.getZoneName(cluster.getZoneId()));
                break;
            }
            case 21: {
                NetworkMap map = (NetworkMap)object;
                this.addPair("Map type", this.getMapTypeDescription(map.getMapType()));
                break;
            }
        }
        if (object instanceof DataCollectionTarget) {
            this.addPair("Number of DCIs", Integer.toString(((DataCollectionTarget)object).getNumDataCollectionItems()));
        }
        if (object.getGeolocation().getType() != 0) {
            Messages.get();
            this.addPair(Messages.GeneralInfo_Location, object.getGeolocation().toString());
            if (object instanceof MobileDevice) {
                MobileDevice md = (MobileDevice)object;
                if (md.getSpeed() >= 0.0f) {
                    Messages.get();
                    this.addPair(Messages.GeneralInfo_Speed, String.valueOf(Double.toString(md.getSpeed())) + " km/h");
                }
                if (md.getDirection() >= 0) {
                    this.addPair("Direction", String.valueOf(Integer.toString(md.getDirection())) + "\u00b0");
                }
                this.addPair("Altitude", String.valueOf(Integer.toString(md.getAltitude())) + " m");
            }
        }
        if (!object.getPostalAddress().isEmpty()) {
            Messages.get();
            this.addPair(Messages.GeneralInfo_PostalAddress, object.getPostalAddress().getAddressLine());
        }
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.GeneralInfo_Title;
    }

    private String getZoneName(int zoneId) {
        Zone zone = ConsoleSharedData.getSession().findZone(zoneId);
        if (zone == null) {
            return Long.toString(zoneId);
        }
        return String.format("%d (%s)", zoneId, zone.getObjectName());
    }

    private String getMapTypeDescription(MapType mapType) {
        switch (mapType) {
            case CUSTOM: {
                return "Custom";
            }
            case HYBRID_TOPOLOGY: {
                return "Hybrid Topology";
            }
            case INTERNAL_TOPOLOGY: {
                return "Internal Topology";
            }
            case IP_TOPOLOGY: {
                return "IP Topology";
            }
            case LAYER2_TOPOLOGY: {
                return "L2 Topology";
            }
            case OSPF_TOPOLOGY: {
                return "OSPF Topology";
            }
        }
        return String.format("Unknown (%d)", mapType.getValue());
    }
}

