/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.elements.NetworkMapElement;

public class NetworkMapObject
extends NetworkMapElement {
    private long objectId;
    private int width;
    private int height;

    protected NetworkMapObject(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        this.objectId = msg.getFieldAsInt64(baseId + 10L);
        this.width = msg.getFieldAsInt32(baseId + 11L);
        this.height = msg.getFieldAsInt32(baseId + 12L);
    }

    public NetworkMapObject(long id, long objectId) {
        super(id);
        this.objectId = objectId;
        this.type = 1;
        this.width = 100;
        this.height = 100;
    }

    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        msg.setFieldInt32(baseId + 10L, (int)this.objectId);
        msg.setFieldInt32(baseId + 11L, this.width);
        msg.setFieldInt32(baseId + 12L, this.height);
    }

    public String toString() {
        return "NetworkMapObject [objectId=" + this.objectId + ", id=" + this.id + ", type=" + this.type + ", x=" + this.x + ", y=" + this.y + " width: " + this.width + " height: " + this.height + "]";
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

