/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.Port;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.topology.widgets.SlotView;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortSelectionListener;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class DeviceView
extends DashboardComposite {
    private long nodeId;
    private NXCSession session;
    private Map<Long, PortInfo> ports = new HashMap<Long, PortInfo>();
    private Map<Long, SlotView> slots = new HashMap<Long, SlotView>();
    private Label header = null;
    private Font headerFont = null;
    private boolean portStatusVisible = true;
    private boolean headerVisible = false;
    private Set<PortSelectionListener> selectionListeners = new HashSet<PortSelectionListener>();
    private PortSelectionListener listener;

    public DeviceView(Composite parent, int style) {
        super(parent, style);
        this.session = ConsoleSharedData.getSession();
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.fill = true;
        layout.wrap = false;
        this.setLayout((Layout)layout);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.listener = new PortSelectionListener(){

            @Override
            public void portSelected(PortInfo port) {
                for (PortSelectionListener l : DeviceView.this.selectionListeners) {
                    l.portSelected(port);
                }
            }
        };
    }

    public void refresh() {
        AbstractObject object = this.session.findObjectById(this.nodeId);
        if (object == null || !(object instanceof Node)) {
            return;
        }
        if (!this.headerVisible && this.header != null) {
            this.header.dispose();
            this.header = null;
        }
        for (SlotView s : this.slots.values()) {
            s.setMenu(null);
            s.dispose();
        }
        this.slots.clear();
        this.ports.clear();
        if (this.headerVisible) {
            if (this.header == null) {
                this.header = new Label((Composite)this, 0);
                this.header.setBackground(this.getBackground());
                if (this.headerFont == null) {
                    this.headerFont = FontTools.createTitleFont();
                    this.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            DeviceView.this.headerFont.dispose();
                        }
                    });
                }
                this.header.setFont(this.headerFont);
            }
            this.header.setText(object.getObjectName());
        }
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        for (AbstractObject o : object.getAllChildren(3)) {
            if (!((Interface)o).isPhysicalPort()) continue;
            interfaces.add((Interface)o);
        }
        Collections.sort(interfaces, new Comparator<Interface>(){

            @Override
            public int compare(Interface arg0, Interface arg1) {
                if (arg0.getModule() == arg1.getModule()) {
                    return arg0.getPort() - arg1.getPort();
                }
                return arg0.getModule() - arg1.getModule();
            }
        });
        for (Interface iface : interfaces) {
            long hash = (long)iface.getChassis() << 32 | (long)iface.getModule();
            SlotView sv = this.slots.get(hash);
            if (sv == null) {
                sv = new SlotView((Composite)this, 0, String.format("%d/%d", iface.getChassis(), iface.getModule()), ((Node)object).getPortRowCount(), ((Node)object).getPortNumberingScheme());
                sv.setPortStatusVisible(this.portStatusVisible);
                this.slots.put(hash, sv);
            }
            PortInfo p = new PortInfo(iface);
            this.ports.put(iface.getObjectId(), p);
            sv.addPort(p);
        }
        this.layout();
        for (SlotView sv : this.slots.values()) {
            sv.setMenu(this.getMenu());
            sv.addSelectionListener(this.listener);
        }
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
        this.refresh();
    }

    public boolean isPortStatusVisible() {
        return this.portStatusVisible;
    }

    public void setPortStatusVisible(boolean portStatusVisible) {
        this.portStatusVisible = portStatusVisible;
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public void setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
    }

    public void setHighlight(Port[] ports) {
        this.clearHighlight(false);
        Port[] portArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                SlotView sv;
                Port p;
                block6: {
                    p = portArray[n2];
                    if (p.getModule() != 0 || p.getPort() != 0) break block6;
                    Interface iface = (Interface)this.session.findObjectById(p.getObjectId(), Interface.class);
                    if (iface == null) break block7;
                    if (iface.isPhysicalPort()) break block6;
                    Interface parent = iface.getParentInterface();
                    if (parent == null || !parent.isPhysicalPort()) break block7;
                    p = new Port(parent.getObjectId(), (long)parent.getIfIndex(), parent.getChassis(), parent.getModule(), parent.getPIC(), parent.getPort());
                }
                if ((sv = this.slots.get((long)p.getChassis() << 32 | (long)p.getModule())) != null) {
                    sv.addHighlight(p);
                }
            }
            ++n2;
        }
        for (SlotView sv : this.slots.values()) {
            sv.redraw();
        }
    }

    public void clearHighlight(boolean doRedraw) {
        for (SlotView sv : this.slots.values()) {
            sv.clearHighlight();
            if (!doRedraw) continue;
            sv.redraw();
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        for (SlotView sv : this.slots.values()) {
            sv.setMenu(this.getMenu());
        }
    }

    public void addSelectionListener(PortSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(PortSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }
}

