/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.services.ToolDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolsPerspective
extends Perspective {
    private static final Logger logger = LoggerFactory.getLogger(ToolsPerspective.class);
    private List<ToolDescriptor> elements = new ArrayList();

    public ToolsPerspective() {
        super("tools", LocalizationHelper.getI18n(ToolsPerspective.class).tr("Tools"), ResourceManager.getImage((String)"icons/perspective-tools.png"));
        ServiceLoader<ToolDescriptor> loader = ServiceLoader.load(ToolDescriptor.class, this.getClass().getClassLoader());
        for (ToolDescriptor e : loader) {
            logger.debug("Adding tools element " + e.getName());
            this.elements.add(e);
        }
        this.elements.sort(new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = false;
        configuration.multiViewMainArea = true;
        configuration.hasSupplementalArea = false;
        configuration.useGlobalViewId = true;
        configuration.ignoreViewContext = true;
        configuration.priority = 200;
    }

    protected void configureViews() {
        for (ToolDescriptor e : this.elements) {
            View view = e.createView();
            this.addMainView(view);
            logger.debug("Added monitor perspective view \"" + view.getName() + "\"");
        }
    }
}

