/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.modules.dashboards.config.LabelConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.FontTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(LabelElement.class);
    private LabelConfig config;
    private Label label;
    private Font font;

    public LabelElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = LabelConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new LabelConfig();
        }
        FillLayout layout = new FillLayout();
        layout.marginHeight = 4;
        this.getContentArea().setLayout((Layout)layout);
        this.label = new Label(this.getContentArea(), 0x1000000);
        this.label.setText(this.config.getTitle());
        this.label.setBackground(this.colors.create(ColorConverter.parseColorDefinition((String)this.config.getTitleBackground())));
        this.label.setForeground(this.colors.create(ColorConverter.parseColorDefinition((String)this.config.getTitleForeground())));
        this.getContentArea().setBackground(this.label.getBackground());
        this.font = FontTools.createAdjustedFont((Font)JFaceResources.getBannerFont(), (int)this.config.getTitleFontSize());
        this.label.setFont(this.font);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected int getPreferredHeight() {
        return 16;
    }
}

