/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logwatch.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.DashboardComposite;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.EventSelector;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserEditor;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserMetricEditor;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserRuleEditor;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserContext;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserEvent;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserMatch;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserMetric;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserRule;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserType;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class LogParserRuleEditor
extends DashboardComposite {
    private static final Color CONDITION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 198, 214, 172);
    private static final Color ACTION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 186, 176, 201);
    private static final Color TITLE_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private final I18n i18n = LocalizationHelper.getI18n(LogParserRuleEditor.class);
    private LogParserRule rule;
    private LogParserEditor editor;
    private LabeledText name;
    private LabeledText regexp;
    private Button checkboxInvert;
    private Button checkboxReset;
    private LabeledSpinner repeatCount;
    private Spinner timeRange;
    private Combo timeUnits;
    private LabeledText severity;
    private LabeledText facility;
    private LabeledText tag;
    private LabeledText logName;
    private LabeledText activeContext;
    private LabeledText description;
    private LabeledText agentAction;
    private EventSelector event;
    private LabeledText eventTag;
    private LabeledText context;
    private Combo contextAction;
    private Combo contextResetMode;
    private Button checkboxBreak;
    private Button checkboxDoNotSaveToDB;
    private ImageHyperlink addMetric;
    private Composite pushDataArea;

    public LogParserRuleEditor(Composite parent, LogParserRule rule, LogParserEditor editor) {
        super(parent, 0);
        this.rule = rule;
        this.editor = editor;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)layout);
        Label separator = new Label((Composite)this, 258);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        separator.setLayoutData((Object)gd);
        Composite controlBar = new Composite((Composite)this, 0);
        controlBar.setLayout((Layout)new RowLayout(256));
        controlBar.setBackground(parent.getBackground());
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        controlBar.setLayoutData((Object)gd);
        this.fillControlBar(controlBar);
        this.name = new LabeledText((Composite)this, 0);
        this.name.setLabel("Name");
        this.name.setBackground(parent.getBackground());
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.name.setLayoutData((Object)gd);
        this.name.setText(rule.getName() != null ? rule.getName() : "");
        this.name.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        2 condition = new /* Unavailable Anonymous Inner Class!! */;
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        condition.setLayoutData((Object)gd);
        3 action = new /* Unavailable Anonymous Inner Class!! */;
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        action.setLayoutData((Object)gd);
    }

    private void fillControlBar(Composite parent) {
        ImageHyperlink link = new ImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_UP);
        link.setToolTipText(this.i18n.tr("Move up"));
        link.setBackground(parent.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        link = new ImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DOWN);
        link.setToolTipText(this.i18n.tr("Move down"));
        link.setBackground(parent.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        link = new ImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setToolTipText(this.i18n.tr("Delete"));
        link.setBackground(parent.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Composite createMatchingArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        7 listener = new /* Unavailable Anonymous Inner Class!! */;
        Composite matcher = new Composite(area, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        matcher.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        matcher.setLayout((Layout)layout);
        this.regexp = new LabeledText(matcher, 0);
        this.regexp.setLabel(this.i18n.tr("Matching regular expression"));
        this.regexp.setText(this.rule.getMatch().getMatch());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.regexp.setLayoutData((Object)gd);
        this.regexp.getTextControl().addModifyListener((ModifyListener)listener);
        this.checkboxInvert = new Button(matcher, 32);
        this.checkboxInvert.setText(this.i18n.tr("Invert"));
        this.checkboxInvert.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkboxInvert.setSelection(this.rule.getMatch().getInvert());
        if (this.editor.getParserType() == LogParserType.POLICY) {
            Composite matcherRepeatConf = new Composite(matcher, 0);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            matcherRepeatConf.setLayoutData((Object)gd);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            matcherRepeatConf.setLayout((Layout)layout);
            this.repeatCount = new LabeledSpinner(matcherRepeatConf, 0);
            this.repeatCount.setLabel(this.i18n.tr("Repeat count"));
            this.repeatCount.getSpinnerControl().setMinimum(0);
            this.repeatCount.setSelection(this.rule.getMatch().getRepeatCount().intValue());
            this.repeatCount.getSpinnerControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.repeatCount.setLayoutData((Object)gd);
            Composite timeBackGroup = new Composite(matcherRepeatConf, 0);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 4;
            layout.numColumns = 2;
            timeBackGroup.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            timeBackGroup.setLayoutData((Object)gd);
            this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeBackGroup, (int)2048, (String)this.i18n.tr("Repeat interval"), (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
            this.timeRange.setSelection(this.rule.getMatch().getTimeRagne());
            this.timeRange.addModifyListener((ModifyListener)listener);
            this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeBackGroup, (int)8, (String)"", (Object)"WidgetHelper::default_layout_data");
            this.timeUnits.add("Seconds");
            this.timeUnits.add("Minutes");
            this.timeUnits.add("Hours");
            this.timeUnits.select(this.rule.getMatch().getTimeUnit());
            this.timeUnits.addModifyListener((ModifyListener)listener);
            this.checkboxReset = new Button(matcherRepeatConf, 32);
            this.checkboxReset.setText("Reset repeat count");
            this.checkboxReset.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.checkboxReset.setSelection(this.rule.getMatch().getReset());
        }
        this.severity = new LabeledText(area, 0);
        this.severity.setLabel(this.editor.getParserType() == LogParserType.SYSLOG ? this.i18n.tr("Severity") : this.i18n.tr("Level"));
        this.severity.setText(this.rule.getSeverityOrLevel(this.editor.getParserType() == LogParserType.SYSLOG));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.severity.setLayoutData((Object)gd);
        this.severity.getTextControl().addModifyListener((ModifyListener)listener);
        this.facility = new LabeledText(area, 0);
        this.facility.setLabel(this.editor.getParserType() == LogParserType.SYSLOG ? this.i18n.tr("Facility") : this.i18n.tr("Event ID or ID range"));
        this.facility.setText(this.rule.getFacilityOrId(this.editor.getParserType() == LogParserType.SYSLOG));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.facility.setLayoutData((Object)gd);
        this.facility.getTextControl().addModifyListener((ModifyListener)listener);
        this.tag = new LabeledText(area, 0);
        this.tag.setLabel(this.editor.getParserType() == LogParserType.SYSLOG ? this.i18n.tr("Tag") : this.i18n.tr("Source"));
        this.tag.setText(this.rule.getTagOrSource(this.editor.getParserType() == LogParserType.SYSLOG));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.tag.setLayoutData((Object)gd);
        this.tag.getTextControl().addModifyListener((ModifyListener)listener);
        if (this.editor.getParserType() == LogParserType.WIN_EVENT) {
            this.logName = new LabeledText(area, 0);
            this.logName.setLabel("Log name");
            this.logName.setText(this.rule.getLogName());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.logName.setLayoutData((Object)gd);
            this.logName.getTextControl().addModifyListener((ModifyListener)listener);
        }
        if (this.editor.getParserType() == LogParserType.POLICY) {
            this.activeContext = new LabeledText(area, 0);
            this.activeContext.setLabel(this.i18n.tr("Active context"));
            this.activeContext.setText(this.rule.getContext() != null ? this.rule.getContext() : "");
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.activeContext.setLayoutData((Object)gd);
            this.activeContext.getTextControl().addModifyListener((ModifyListener)listener);
        }
        this.description = new LabeledText(area, 0);
        this.description.setLabel(this.i18n.tr("Description"));
        this.description.setText(this.rule.getDescription() != null ? this.rule.getDescription() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.description.setLayoutData((Object)gd);
        this.description.getTextControl().addModifyListener((ModifyListener)listener);
        this.updateWindowsEventLogFields();
        return area;
    }

    public void updateWindowsEventLogFields() {
        if (this.editor.getParserType() == LogParserType.SYSLOG) {
            return;
        }
        if (this.editor.isWindowsEventLogParser() || this.editor.getParserType() == LogParserType.WIN_EVENT) {
            this.severity.setEnabled(true);
            this.facility.setEnabled(true);
            this.tag.setEnabled(true);
        } else {
            this.severity.setEnabled(false);
            this.facility.setEnabled(false);
            this.tag.setEnabled(false);
        }
    }

    private Composite createActionArea(Composite parent) {
        int eventCode;
        GridLayout layout;
        Composite area;
        block12: {
            area = new Composite(parent, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            area.setLayout((Layout)layout);
            eventCode = 0;
            if (this.rule.getEvent() != null) {
                try {
                    eventCode = Integer.parseInt(this.rule.getEvent().getEvent());
                }
                catch (NumberFormatException e) {
                    EventTemplate tmpl = Registry.getSession().findEventTemplateByName(this.rule.getEvent().getEvent());
                    if (tmpl == null) break block12;
                    eventCode = tmpl.getCode();
                }
            }
        }
        this.event = new EventSelector(area, 0, new SelectorConfigurator().setUseHyperlink(true).setShowClearButton(true));
        this.event.setLabel(this.i18n.tr("Generate event"));
        this.event.setEventCode(eventCode);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.event.setLayoutData((Object)gd);
        this.event.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        String eventTagText = "";
        if (this.rule.getEvent() != null) {
            eventTagText = this.rule.getEvent().getEventTag() != null ? this.rule.getEvent().getEventTag() : "";
        }
        this.eventTag = new LabeledText(area, 0);
        this.eventTag.setLabel(this.i18n.tr("Event tag"));
        this.eventTag.setText(eventTagText);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.eventTag.setLayoutData((Object)gd);
        this.eventTag.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.eventTag.setEnabled(this.event.getEventCode() != 0);
        if (this.editor.getParserType() == LogParserType.POLICY) {
            LogParserContext contextDefinition = this.rule.getContextDefinition();
            this.context = new LabeledText(area, 0);
            this.context.setLabel(this.i18n.tr("Change context"));
            this.context.setText(contextDefinition != null ? contextDefinition.getData() : "");
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.context.setLayoutData((Object)gd);
            this.context.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            Composite contextOptions = new Composite(area, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = true;
            contextOptions.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            contextOptions.setLayoutData((Object)gd);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.contextAction = WidgetHelper.createLabeledCombo((Composite)contextOptions, (int)8, (String)this.i18n.tr("Context action"), (Object)gd);
            this.contextAction.add(this.i18n.tr("Activate"));
            this.contextAction.add(this.i18n.tr("Clear"));
            if (contextDefinition != null) {
                this.contextAction.select(contextDefinition.getAction());
            } else {
                this.contextAction.select(0);
                this.contextAction.setEnabled(false);
            }
            this.contextAction.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.contextResetMode = WidgetHelper.createLabeledCombo((Composite)contextOptions, (int)8, (String)this.i18n.tr("Context reset mode"), (Object)gd);
            this.contextResetMode.add(this.i18n.tr("Automatic"));
            this.contextResetMode.add(this.i18n.tr("Manual"));
            if (contextDefinition != null) {
                this.contextResetMode.select(contextDefinition.getReset());
                this.contextResetMode.setEnabled(contextDefinition.getAction() == 0);
            } else {
                this.contextResetMode.select(0);
                this.contextResetMode.setEnabled(false);
            }
            this.contextResetMode.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.editor.getParserType() == LogParserType.POLICY) {
            this.agentAction = new LabeledText(area, 0);
            this.agentAction.setLabel(this.i18n.tr("Execute action"));
            this.agentAction.setText(this.rule.getAgentAction() != null ? this.rule.getAgentAction().getAction() : "");
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.agentAction.setLayoutData((Object)gd);
            this.agentAction.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            this.pushDataArea = new Composite(area, 0);
            GridLayout pushDataAreaLayout = new GridLayout();
            pushDataAreaLayout.marginHeight = 0;
            pushDataAreaLayout.marginWidth = 0;
            pushDataAreaLayout.makeColumnsEqualWidth = false;
            this.pushDataArea.setLayout((Layout)pushDataAreaLayout);
            this.pushDataArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            for (LogParserMetric metric : this.rule.getMetrics()) {
                this.createMetricEditor(metric);
            }
            this.addMetric = new ImageHyperlink(this.pushDataArea, 0);
            this.addMetric.setText(this.i18n.tr("Add metric"));
            this.addMetric.setImage(SharedIcons.IMG_ADD_OBJECT);
            this.addMetric.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.checkboxBreak = new Button(area, 32);
        this.checkboxBreak.setText(this.i18n.tr("Break"));
        this.checkboxBreak.setSelection(this.rule.isBreakProcessing());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkboxBreak.setLayoutData((Object)gd);
        this.checkboxBreak.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.editor.getParserType() != LogParserType.POLICY) {
            this.checkboxDoNotSaveToDB = new Button(area, 32);
            this.checkboxDoNotSaveToDB.setText(this.i18n.tr("Do not save to database"));
            this.checkboxDoNotSaveToDB.setSelection(this.rule.isDoNotSaveToDatabase());
            this.checkboxDoNotSaveToDB.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return area;
    }

    private LogParserMetricEditor createMetricEditor(LogParserMetric metric) {
        LogParserMetricEditor editor = new LogParserMetricEditor(this.pushDataArea, metric, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData((Object)gd);
        metric.setEditor(editor);
        return editor;
    }

    protected void addMetric() {
        LogParserMetric metric = new LogParserMetric();
        LogParserMetricEditor metricEditor = this.createMetricEditor(metric);
        metricEditor.moveAbove((Control)this.addMetric);
        this.rule.getMetrics().add(metric);
        this.editor.updateScroller();
        this.fireModifyListeners();
    }

    public void deleteMetric(LogParserMetric metric) {
        this.rule.getMetrics().remove(metric);
        metric.getEditor().dispose();
        this.editor.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void save() {
        this.rule.setName(this.name.getText().trim());
        if (this.editor.getParserType() == LogParserType.POLICY) {
            this.rule.setMatch(new LogParserMatch(this.regexp.getText(), this.checkboxInvert.getSelection(), this.intOrNull(this.repeatCount.getText()), Integer.valueOf(Integer.parseInt(this.timeRange.getText()) * (int)Math.pow(60.0, this.timeUnits.getSelectionIndex())), this.checkboxReset.getSelection()));
        } else {
            this.rule.setMatch(new LogParserMatch(this.regexp.getText(), this.checkboxInvert.getSelection(), null, Integer.valueOf(0), false));
        }
        this.rule.setEventId(this.facility.getText());
        this.rule.setSeverityOrLevel(this.intOrNull(this.severity.getText()));
        this.rule.setTagOrSource(this.tag.getText());
        if (this.editor.getParserType() == LogParserType.WIN_EVENT) {
            this.rule.setLogName(this.logName.getText());
        } else {
            this.rule.setLogName("");
        }
        if (this.editor.getParserType() == LogParserType.POLICY) {
            this.rule.setContext(this.activeContext.getText().trim().isEmpty() ? null : this.activeContext.getText());
        } else {
            this.rule.setContext(null);
        }
        this.rule.setBreakProcessing(this.checkboxBreak.getSelection());
        this.rule.setDescription(this.description.getText());
        if (this.event.getEventCode() != 0) {
            this.rule.setEvent(new LogParserEvent(this.event.getEventName() != null ? this.event.getEventName() : Long.toString(this.event.getEventCode()), null, this.eventTag.getText().isEmpty() ? null : this.eventTag.getText()));
        } else {
            this.rule.setEvent(null);
        }
        if (this.editor.getParserType() != LogParserType.POLICY || this.context.getText().trim().isEmpty()) {
            this.rule.setContextDefinition(null);
        } else {
            LogParserContext ctx = new LogParserContext();
            ctx.setData(this.context.getText());
            ctx.setAction(this.contextAction.getSelectionIndex());
            ctx.setReset(this.contextResetMode.getSelectionIndex());
            this.rule.setContextDefinition(ctx);
        }
        if (this.editor.getParserType() == LogParserType.POLICY) {
            this.rule.setAgentAction(this.agentAction.getText().trim());
        } else {
            this.rule.setAgentAction("");
        }
        if (this.editor.getParserType() == LogParserType.POLICY) {
            for (LogParserMetric metric : this.rule.getMetrics()) {
                metric.getEditor().save();
            }
        } else {
            this.rule.setMetrics(null);
        }
        if (this.editor.getParserType() != LogParserType.POLICY) {
            this.rule.setDoNotSaveToDatabase(this.checkboxDoNotSaveToDB.getSelection());
        } else {
            this.rule.setDoNotSaveToDatabase(false);
        }
    }

    private Integer intOrNull(String text) {
        if (text.trim().isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public LogParserType getParserType() {
        return this.editor.getParserType();
    }

    public void fireModifyListeners() {
        this.editor.fireModifyListeners();
    }

    public void dispose() {
        if (this.rule.getMetrics() != null) {
            for (LogParserMetric metric : this.rule.getMetrics()) {
                metric.getEditor().dispose();
            }
        }
        super.dispose();
    }
}

