/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets.helpers;

import java.text.DateFormat;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.reporting.ReportResult;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class ReportResultLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(ReportResultLabelProvider.class);
    private NXCSession session = Registry.getSession();
    private DateFormat dateFormat = DateFormatFactory.getDateTimeFormat();
    private SortableTableViewer viewer;

    public ReportResultLabelProvider(SortableTableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ReportResult reportResult = (ReportResult)element;
        switch (columnIndex) {
            case 0: {
                return this.dateFormat.format(reportResult.getExecutionTime());
            }
            case 1: {
                AbstractUserObject user = this.session.findUserDBObjectById(reportResult.getUserId(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + reportResult.getUserId() + "]";
            }
            case 2: {
                return reportResult.isSuccess() ? this.i18n.tr("Success") : this.i18n.tr("Failure");
            }
        }
        return "<INTERNAL ERROR>";
    }
}

