/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs.helpers;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SnmpTrapComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc;
        TableColumn sortColumn = ((TableViewer)viewer).getTable().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        SnmpTrap trap1 = (SnmpTrap)e1;
        SnmpTrap trap2 = (SnmpTrap)e2;
        switch ((Integer)sortColumn.getData("ID")) {
            case 0: {
                rc = trap1.getObjectId().compareTo(trap2.getObjectId());
                break;
            }
            case 1: {
                EventTemplate evt1 = this.session.findEventTemplateByCode(trap1.getEventCode());
                EventTemplate evt2 = this.session.findEventTemplateByCode(trap2.getEventCode());
                String name1 = evt1 != null ? evt1.getName() : "[" + Integer.toString(trap1.getEventCode()) + "]";
                String name2 = evt2 != null ? evt2.getName() : "[" + Integer.toString(trap2.getEventCode()) + "]";
                rc = name1.compareToIgnoreCase(name2);
                break;
            }
            case 2: {
                rc = trap1.getDescription().compareToIgnoreCase(trap2.getDescription());
                break;
            }
            default: {
                rc = 0;
            }
        }
        int dir = ((TableViewer)viewer).getTable().getSortDirection();
        return dir == 128 ? rc : -rc;
    }
}

