/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.filemanager.widgets.LocalFileSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ImportConfiguration
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.ImportConfiguration";
    private LocalFileSelector fileSelector;
    private Button buttonImport;
    private Group options;
    private List<Button> buttonFlags = new ArrayList<Button>();
    private Button buttonSelectAll;
    private Button buttonDeselectAll;
    private StyledText text;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.fileSelector = new LocalFileSelector(parent, 0, false, 4100);
        Messages.get();
        this.fileSelector.setLabel(Messages.ConfigurationImportDialog_FileName);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.fileSelector.setLayoutData((Object)gd);
        this.fileSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportConfiguration.this.buttonImport.setEnabled(ImportConfiguration.this.fileSelector.getFile() != null);
            }
        });
        this.buttonImport = new Button(parent, 8);
        this.buttonImport.setText("Import");
        this.buttonImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportConfiguration.this.doImport();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.widthHint = 90;
        this.buttonImport.setLayoutData((Object)gd);
        this.buttonImport.setEnabled(false);
        this.options = new Group(parent, 0);
        this.options.setText("Options");
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.numColumns = 3;
        this.options.setLayout((Layout)optionsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.options.setLayoutData((Object)gd);
        this.addOptionCheckBox("Replace &actions", 2);
        this.addOptionCheckBox("Replace asset &management attributes", 2048);
        this.addOptionCheckBox("Replace &DCI summary tables", 32);
        this.addOptionCheckBox("Replace EPP &rules", 128);
        this.addOptionCheckBox("Replace &events", 1);
        this.addOptionCheckBox("Replace library &scripts", 16);
        this.addOptionCheckBox("Replace &object tools", 64);
        this.addOptionCheckBox("Replace S&NMP traps", 8);
        this.addOptionCheckBox("Replace &templates", 4);
        this.addOptionCheckBox("Replace template names and &locations", 256);
        this.addOptionCheckBox("Replace &web service definitions", 1024);
        this.addOptionCheckBox("Remove empty template &groups after import", 512);
        Composite buttons = new Composite((Composite)this.options, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        buttons.setLayoutData((Object)gd);
        this.buttonSelectAll = new Button(buttons, 8);
        this.buttonSelectAll.setText("&Select all");
        this.buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button button : ImportConfiguration.this.buttonFlags) {
                    button.setSelection(true);
                }
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 90;
        this.buttonSelectAll.setLayoutData((Object)gd);
        this.buttonDeselectAll = new Button(buttons, 8);
        this.buttonDeselectAll.setText("&Clear all");
        this.buttonDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button button : ImportConfiguration.this.buttonFlags) {
                    button.setSelection(false);
                }
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 90;
        this.buttonDeselectAll.setLayoutData((Object)gd);
        new Label(parent, 0).setText("Import log");
        this.text = new StyledText(parent, 2816);
        this.text.setEditable(false);
        this.text.setFont(JFaceResources.getTextFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.text.setLayoutData((Object)gd);
    }

    private void addOptionCheckBox(String text, int flag) {
        Button button = new Button((Composite)this.options, 32);
        button.setText(text);
        button.setData("BitFlag", (Object)flag);
        this.buttonFlags.add(button);
    }

    private void doImport() {
        this.text.setText("");
        int flagBuilder = 0;
        for (Button button : this.buttonFlags) {
            if (!button.getSelection()) continue;
            flagBuilder |= ((Integer)button.getData("BitFlag")).intValue();
        }
        final int flags = flagBuilder;
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ImportConfiguration_JobName, null, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final String result = session.importConfiguration(ImportConfiguration.this.fileSelector.getFile(), flags);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).ImportConfiguration.this.text.setText(String.valueOf(result) + "[SUCCESS] Import completed successfully");
                        }
                    });
                }
                catch (NXCException e) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            String output = e.getAdditionalInfo();
                            (this).ImportConfiguration.this.text.setText(String.valueOf(output != null ? output : "") + "[FAILURE] Import failed (" + e.getLocalizedMessage() + ")");
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ImportConfiguration_JobError;
            }
        };
        job.start();
    }

    public void setFocus() {
        this.fileSelector.setFocus();
    }
}

