/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.asset;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.AMDataType;
import org.netxms.client.constants.AMSystemType;

public class AssetAttribute {
    String name;
    String displayName;
    AMDataType dataType;
    boolean mandatory;
    boolean unique;
    boolean hidden;
    String autofillScript;
    int rangeMin;
    int rangeMax;
    AMSystemType systemType;
    Map<String, String> enumValues;

    public AssetAttribute() {
        this.name = "";
        this.displayName = "";
        this.dataType = AMDataType.STRING;
        this.mandatory = false;
        this.unique = false;
        this.hidden = false;
        this.autofillScript = "";
        this.rangeMin = 0;
        this.rangeMax = 0;
        this.systemType = AMSystemType.NONE;
        this.enumValues = new HashMap<String, String>();
    }

    public AssetAttribute(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId++);
        this.displayName = msg.getFieldAsString(baseId++);
        this.dataType = AMDataType.getByValue(msg.getFieldAsInt32(baseId++));
        this.mandatory = msg.getFieldAsBoolean(baseId++);
        this.unique = msg.getFieldAsBoolean(baseId++);
        this.hidden = msg.getFieldAsBoolean(baseId++);
        this.autofillScript = msg.getFieldAsString(baseId++);
        this.rangeMin = msg.getFieldAsInt32(baseId++);
        this.rangeMax = msg.getFieldAsInt32(baseId++);
        this.systemType = AMSystemType.getByValue(msg.getFieldAsInt32(baseId++));
        this.enumValues = msg.getStringMapFromFields(baseId + 1L, baseId);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(20L, this.name);
        msg.setField(821L, this.displayName);
        msg.setFieldInt32(814L, this.dataType.getValue());
        msg.setField(815L, this.mandatory);
        msg.setField(816L, this.unique);
        msg.setField(832L, this.hidden);
        msg.setField(228L, this.autofillScript);
        msg.setFieldInt32(817L, this.rangeMin);
        msg.setFieldInt32(818L, this.rangeMax);
        msg.setFieldInt32(819L, this.systemType.getValue());
        msg.setFieldsFromStringMap(this.enumValues, 0x20000000L, 820L);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEffectiveDisplayName() {
        return this.displayName.isEmpty() ? this.name : this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public AMDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(AMDataType dataType) {
        this.dataType = dataType;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean isMandatory) {
        this.mandatory = isMandatory;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean isUnique) {
        this.unique = isUnique;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getAutofillScript() {
        return this.autofillScript;
    }

    public void setAutofillScript(String autofillScript) {
        this.autofillScript = autofillScript;
    }

    public int getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(int rangeMin) {
        this.rangeMin = rangeMin;
    }

    public int getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(int rangeMax) {
        this.rangeMax = rangeMax;
    }

    public AMSystemType getSystemType() {
        return this.systemType;
    }

    public void setSystemType(AMSystemType systemType) {
        this.systemType = systemType;
    }

    public Map<String, String> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(Map<String, String> enumMapping) {
        this.enumValues = enumMapping;
    }
}

