/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.NXCPMessage;

public class MapDCIInstance {
    private long dciID;
    private long nodeID;
    private int type;
    private String column;
    private String instance;
    private Map<Long, Integer> mapObjectIdList = new HashMap<Long, Integer>();

    public MapDCIInstance(long dciID, long nodeID, String column, String instance, int type, long mapObjectId) {
        this.setDciID(dciID);
        this.setNodeID(nodeID);
        this.setColumn(column);
        this.setInstance(instance);
        this.type = type;
        this.mapObjectIdList.put(mapObjectId, 1);
    }

    public MapDCIInstance(long dciID, long nodeID, int type, long mapObjectId) {
        this.setDciID(dciID);
        this.setNodeID(nodeID);
        this.setColumn("");
        this.setInstance("");
        this.type = type;
        this.mapObjectIdList.put(mapObjectId, 1);
    }

    public void addMap(long mapId) {
        Integer count = this.mapObjectIdList.get(mapId);
        if (count != null) {
            this.mapObjectIdList.put(mapId, count + 1);
        } else {
            this.mapObjectIdList.put(mapId, 1);
        }
    }

    public boolean removeMap(long mapId) {
        Integer count = this.mapObjectIdList.get(mapId);
        if (count != null) {
            if (count > 1) {
                this.mapObjectIdList.put(mapId, count - 1);
            } else {
                this.mapObjectIdList.remove(mapId);
            }
        }
        return this.mapObjectIdList.isEmpty();
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public long getDciID() {
        return this.dciID;
    }

    public void setDciID(long dciID) {
        this.dciID = dciID;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(long nodeID) {
        this.nodeID = nodeID;
    }

    public void fillMessage(NXCPMessage msg, long base) {
        if (this.type == 2 && (this.column.isEmpty() || this.instance.isEmpty())) {
            return;
        }
        msg.setFieldInt32(base++, (int)this.nodeID);
        msg.setFieldInt32(base++, (int)this.dciID);
        msg.setFieldInt32(base++, this.mapObjectIdList.entrySet().iterator().next().getKey().intValue());
        if (this.type == 2) {
            msg.setField(base++, this.column);
            msg.setField(base++, this.instance);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.column == null || this.type == 2 ? 0 : this.column.hashCode());
        result = 31 * result + (int)(this.dciID ^ this.dciID >>> 32);
        result = 31 * result + (this.instance == null || this.type == 2 ? 0 : this.instance.hashCode());
        result = 31 * result + (int)(this.nodeID ^ this.nodeID >>> 32);
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MapDCIInstance)) {
            return false;
        }
        MapDCIInstance i = (MapDCIInstance)object;
        if (i.type != this.type) {
            return false;
        }
        boolean bl = result = i.dciID == this.dciID;
        if (result && i.type == 2) {
            result = i.column.equals(this.column) && i.instance.equals(this.instance);
        }
        return result;
    }
}

