/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentTunnel;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.TunnelListComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.TunnelListLabelProvider;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.TunnelManagerFilter;
import org.netxms.nxmc.modules.objects.dialogs.CreateNodeDialog;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class TunnelManager
extends ConfigurationView
implements SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(TunnelManager.class);
    private final I18n i18n = LocalizationHelper.getI18n(TunnelManager.class);
    public static final String ID = "TunnelManager";
    public static final int COL_ID = 0;
    public static final int COL_STATE = 1;
    public static final int COL_NODE = 2;
    public static final int COL_IP_ADDRESS = 3;
    public static final int COL_CHANNELS = 4;
    public static final int COL_SYSNAME = 5;
    public static final int COL_HOSTNAME = 6;
    public static final int COL_PLATFORM = 7;
    public static final int COL_SYSINFO = 8;
    public static final int COL_HARDWARE_ID = 9;
    public static final int COL_SERIAL_NUMBER = 10;
    public static final int COL_AGENT_VERSION = 11;
    public static final int COL_AGENT_ID = 12;
    public static final int COL_AGENT_PROXY = 13;
    public static final int COL_SNMP_PROXY = 14;
    public static final int COL_SNMP_TRAP_PROXY = 15;
    public static final int COL_SYSLOG_PROXY = 16;
    public static final int COL_USER_AGENT = 17;
    public static final int COL_CERTIFICATE_EXPIRATION = 18;
    public static final int COL_CONNECTION_TIME = 19;
    private NXCSession session = Registry.getSession();
    private Map<Integer, AgentTunnel> tunnels = new HashMap();
    private SortableTableViewer viewer;
    private TunnelManagerFilter filter;
    private Action actionCreateNode;
    private Action actionBind;
    private Action actionUnbind;
    private Action actionHideNonProxy;
    private Action actionHideNonUA;
    private Action actionExportToCsv;

    public TunnelManager() {
        super(LocalizationHelper.getI18n(TunnelManager.class).tr("Agent Tunnels"), ResourceManager.getImageDescriptor((String)"icons/config-views/tunnel_manager.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("State"), this.i18n.tr("Node"), this.i18n.tr("IP address"), this.i18n.tr("Channels"), this.i18n.tr("System name"), this.i18n.tr("Hostname"), this.i18n.tr("Platform"), this.i18n.tr("System information"), this.i18n.tr("Hardware ID"), this.i18n.tr("Serial number"), this.i18n.tr("Agent version"), this.i18n.tr("Agent ID"), this.i18n.tr("Agent proxy"), this.i18n.tr("SNMP proxy"), this.i18n.tr("SNMP trap proxy"), this.i18n.tr("Syslog proxy"), this.i18n.tr("User agent"), this.i18n.tr("Certificate expiration"), this.i18n.tr("Connection time")};
        int[] widths = new int[]{80, 80, 140, 150, 80, 150, 150, 250, 300, 180, 150, 150, 150, 80, 80, 80, 80, 80, 130, 130};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TunnelListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TunnelListComparator());
        this.filter = new TunnelManagerFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)ID);
        this.viewer.getTable().addDisposeListener((DisposeListener & Serializable)e -> WidgetHelper.saveTableViewerSettings((SortableTableViewer)this.viewer, (String)ID));
        this.createActions();
        this.createPopupMenu();
        this.refresh();
        this.session.addListener((SessionListener)this);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        new /* Unavailable Anonymous Inner Class!! */.start();
        super.dispose();
    }

    private void createActions() {
        this.actionCreateNode = new /* Unavailable Anonymous Inner Class!! */;
        this.actionBind = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUnbind = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideNonProxy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideNonUA = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && !((AgentTunnel)selection.getFirstElement()).isBound()) {
            manager.add((IAction)this.actionBind);
            manager.add((IAction)this.actionCreateNode);
            manager.add((IContributionItem)new Separator());
        } else {
            for (Object o : selection.toList()) {
                if (!((AgentTunnel)o).isBound()) continue;
                manager.add((IAction)this.actionUnbind);
                manager.add((IContributionItem)new Separator());
                break;
            }
        }
        manager.add((IAction)this.actionHideNonProxy);
        manager.add((IAction)this.actionHideNonUA);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        super.fillLocalMenu(manager);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNode() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        CreateNodeDialog dlg = new CreateNodeDialog(this.getWindow().getShell(), null);
        dlg.setEnableShowAgainFlag(false);
        dlg.setObjectName(tunnel.getSystemName());
        dlg.setZoneUIN(tunnel.getZoneUIN());
        if (dlg.open() != 0) {
            return;
        }
        NXCObjectCreationData cd = new NXCObjectCreationData(2, dlg.getObjectName(), 2L);
        cd.setCreationFlags(dlg.getCreationFlags());
        cd.setPrimaryName(dlg.getHostName());
        cd.setObjectAlias(dlg.getObjectAlias());
        cd.setAgentPort(dlg.getAgentPort());
        cd.setAgentProxyId(dlg.getAgentProxy());
        cd.setSnmpPort(dlg.getSnmpPort());
        cd.setSnmpProxyId(dlg.getSnmpProxy());
        cd.setIcmpProxyId(dlg.getIcmpProxy());
        cd.setEtherNetIpPort(dlg.getEtherNetIpPort());
        cd.setEtherNetIpProxyId(dlg.getEtherNetIpProxy());
        cd.setModbusTcpPort(dlg.getModbusTcpPort());
        cd.setModbusUnitId(dlg.getModbusUnitId());
        cd.setModbusProxyId(dlg.getModbusProxy());
        cd.setWebServiceProxyId(dlg.getWebServiceProxy());
        cd.setSshPort(dlg.getSshPort());
        cd.setSshProxyId(dlg.getSshProxy());
        cd.setSshLogin(dlg.getSshLogin());
        cd.setSshPassword(dlg.getSshPassword());
        cd.setMqttProxyId(dlg.getMqttProxy());
        cd.setZoneUIN(dlg.getZoneUIN());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void bindTunnel() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        if (dlg.open() != 0) {
            return;
        }
        long nodeId = ((AbstractObject)dlg.getSelectedObjects().get(0)).getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void unbindTunnel() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Unbind Tunnel"), (String)this.i18n.tr("Selected tunnels will be unbound. Are you sure?"))) {
            return;
        }
        Object[] tunnels = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1061) {
            this.getDisplay().asyncExec(() -> {
                AgentTunnel t = (AgentTunnel)n.getObject();
                this.tunnels.put(t.getId(), t);
                this.viewer.refresh();
            });
        } else if (n.getCode() == 1062) {
            this.getDisplay().asyncExec(() -> {
                this.tunnels.remove((int)n.getSubCode());
                this.viewer.refresh();
            });
        }
    }
}

