/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ScriptEditorView
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(ScriptEditorView.class);
    private NXCSession session;
    private ScriptEditor editor;
    private long scriptId;
    private String scriptName;
    private boolean modified = false;
    private boolean showLineNumbers = true;
    private Action actionSave;
    private Action actionCompile;
    private Action actionShowLineNumbers;
    private Action actionGoToLine;
    private String savedScript = null;

    public ScriptEditorView(long scriptId, String scriptName) {
        super(scriptName, ResourceManager.getImageDescriptor((String)"icons/config-views/script-editor.png"), "configuration.script-editor." + Long.toString(scriptId), false);
        this.scriptId = scriptId;
        this.scriptName = scriptName;
        this.session = Registry.getSession();
    }

    public ScriptEditorView() {
        super(null, ResourceManager.getImageDescriptor((String)"icons/config-views/script-editor.png"), null, false);
        this.scriptId = 0L;
        this.scriptName = "";
        this.session = Registry.getSession();
    }

    public View cloneView() {
        ScriptEditorView view = (ScriptEditorView)super.cloneView();
        view.scriptId = this.scriptId;
        view.scriptName = this.scriptName;
        return view;
    }

    protected void postClone(View origin) {
        ScriptEditorView view = (ScriptEditorView)origin;
        this.editor.setText(view.editor.getText());
        this.modified = view.modified;
        this.actionSave.setEnabled(this.modified);
    }

    protected void createContent(Composite parent) {
        this.editor = new /* Unavailable Anonymous Inner Class!! */;
        this.editor.showLineNumbers(this.showLineNumbers);
        this.editor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        if (this.savedScript != null) {
            this.modified = true;
            this.actionSave.setEnabled(true);
            this.editor.setText(this.savedScript);
            this.savedScript = null;
        } else {
            this.refresh();
        }
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
        this.actionCompile = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F2", (IAction)this.actionCompile);
        this.actionShowLineNumbers = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLineNumbers.setChecked(this.showLineNumbers);
        this.addKeyBinding("M1+M3+L", (IAction)this.actionShowLineNumbers);
        this.actionGoToLine = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+G", (IAction)this.actionGoToLine);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionGoToLine);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowLineNumbers);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCompile);
        manager.add((IAction)this.actionSave);
        super.fillLocalMenu(manager);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionGoToLine);
        manager.add((IAction)this.actionCompile);
        manager.add((IAction)this.actionSave);
        super.fillLocalToolBar(manager);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void saveScript() {
        String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void save() {
        String source = this.editor.getText();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        if (!this.editor.isDisposed()) {
            this.editor.setFocus();
        }
    }

    public boolean isCloseable() {
        return true;
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("scriptId", this.scriptId);
        memento.set("scriptName", this.scriptName);
        if (this.modified) {
            memento.set("savedScript", this.editor.getText());
        }
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.scriptId = memento.getAsLong("scriptId", 0L);
        this.scriptName = memento.getAsString("scriptName");
        this.savedScript = memento.getAsString("savedScript", null);
        this.setName(this.scriptName);
    }
}

