/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;

public class FdbEntry {
    private MacAddress address;
    private int interfaceIndex;
    private String interfaceName;
    private int port;
    private long nodeId;
    private int vlanId;
    private int type;

    public FdbEntry(NXCPMessage msg, long baseId) {
        this.address = msg.getFieldAsMacAddress(baseId);
        this.interfaceIndex = msg.getFieldAsInt32(baseId + 1L);
        this.port = msg.getFieldAsInt32(baseId + 2L);
        this.nodeId = msg.getFieldAsInt64(baseId + 3L);
        this.vlanId = msg.getFieldAsInt32(baseId + 4L);
        this.type = msg.getFieldAsInt32(baseId + 5L);
        this.interfaceName = msg.getFieldAsString(baseId + 6L);
    }

    public MacAddress getAddress() {
        return this.address;
    }

    public int getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public int getPort() {
        return this.port;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "FdbEntry [address=" + this.address + ", interfaceIndex=" + this.interfaceIndex + ", port=" + this.port + ", nodeId=" + this.nodeId + ", vlanId=" + this.vlanId + ", type=" + this.type + "]";
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }
}

