/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartConfigurationChangeListener;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.compatibility.GraphItem;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.dialogs.SaveGraphDlg;
import org.netxms.ui.eclipse.perfview.propertypages.DataSources;
import org.netxms.ui.eclipse.perfview.propertypages.General;
import org.netxms.ui.eclipse.perfview.propertypages.Graph;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class HistoricalGraphView
extends ViewPart
implements ChartConfigurationChangeListener {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.HistoryGraph";
    public static final String PREDEFINED_GRAPH_SUBID = "org.netxms.ui.eclipse.charts.predefinedGraph";
    private static final TimeUnit[] presetUnits = new TimeUnit[]{TimeUnit.MINUTE, TimeUnit.MINUTE, TimeUnit.HOUR, TimeUnit.HOUR, TimeUnit.HOUR, TimeUnit.HOUR, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY, TimeUnit.DAY};
    private static final int[] presetRanges = new int[]{10, 30, 1, 2, 4, 12, 1, 2, 5, 7, 31, 365};
    private static final String[] presetNames;
    private NXCSession session;
    private Chart chart = null;
    private boolean updateInProgress = false;
    private ViewRefreshController refreshController;
    private Composite chartParent = null;
    private GraphDefinition configuration = new GraphDefinition();
    private boolean multipleSourceNodes = false;
    private Action actionRefresh;
    private Action actionAutoRefresh;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action actionLogScale;
    private Action actionStacked;
    private Action actionAreaChart;
    private Action actionTranslucent;
    private Action actionShowLegend;
    private Action actionExtendedLegend;
    private Action actionLegendLeft;
    private Action actionLegendRight;
    private Action actionLegendTop;
    private Action actionLegendBottom;
    private Action actionProperties;
    private Action actionSave;
    private Action actionSaveAs;
    private Action actionSaveAsTemplate;
    private Action[] presetActions;
    private Action actionCopyImage;
    private Action actionSaveAsImage;

    static {
        String[] stringArray = new String[12];
        Messages.get();
        stringArray[0] = Messages.HistoricalGraphView_Preset10min;
        Messages.get();
        stringArray[1] = Messages.HistoricalGraphView_Preset30min;
        Messages.get();
        stringArray[2] = Messages.HistoricalGraphView_Preset1hour;
        Messages.get();
        stringArray[3] = Messages.HistoricalGraphView_Preset2hours;
        Messages.get();
        stringArray[4] = Messages.HistoricalGraphView_Preset4hours;
        Messages.get();
        stringArray[5] = Messages.HistoricalGraphView_Preset12hours;
        Messages.get();
        stringArray[6] = Messages.HistoricalGraphView_Preset1day;
        Messages.get();
        stringArray[7] = Messages.HistoricalGraphView_Preset2days;
        Messages.get();
        stringArray[8] = Messages.HistoricalGraphView_Preset5days;
        Messages.get();
        stringArray[9] = Messages.HistoricalGraphView_PresetWeek;
        Messages.get();
        stringArray[10] = Messages.HistoricalGraphView_PresetMonth;
        Messages.get();
        stringArray[11] = Messages.HistoricalGraphView_PresetYear;
        presetNames = stringArray;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.refreshController = new ViewRefreshController((IViewPart)this, -1, new Runnable(){

            @Override
            public void run() {
                if (HistoricalGraphView.this.chart.isDisposed()) {
                    return;
                }
                HistoricalGraphView.this.updateChart();
            }
        });
        this.session = ConsoleSharedData.getSession();
        String id = site.getSecondaryId();
        String[] fields = id.split("&");
        if (!fields[0].equals(PREDEFINED_GRAPH_SUBID)) {
            this.configuration.setTimePeriod(new TimePeriod(TimeFrameType.BACK_FROM_NOW, this.session.getClientConfigurationHintAsInt("DefaultLineChartPeriod", 60), TimeUnit.MINUTE, null, null));
            ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>();
            int i = 1;
            while (i < fields.length) {
                String[] subfields = fields[i].split("\\@");
                if (subfields.length != 0) {
                    ChartDciConfig dci;
                    if (Integer.parseInt(subfields[0]) == 1) {
                        try {
                            dci = new ChartDciConfig();
                            dci.type = Integer.parseInt(subfields[0]);
                            dci.nodeId = Long.parseLong(subfields[1], 10);
                            dci.dciId = Long.parseLong(subfields[2], 10);
                            dci.name = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.dciDescription = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.dciName = URLDecoder.decode(subfields[4], "UTF-8");
                            if (subfields.length >= 6) {
                                dci.useRawValues = Boolean.parseBoolean(subfields[5]);
                            }
                            if (subfields.length >= 7) {
                                dci.invertValues = Boolean.parseBoolean(subfields[6]);
                            }
                            if (subfields.length >= 8) {
                                dci.lineChartType = Integer.parseInt(subfields[7]);
                            }
                            if (subfields.length >= 9) {
                                Integer color = Integer.parseInt(subfields[8]);
                                dci.color = color == -1 ? "UNSET" : "0x" + Integer.toHexString(color);
                            }
                            if (subfields.length >= 10) {
                                this.configuration.setStacked(Boolean.parseBoolean(subfields[9]));
                            }
                            items.add(dci);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    } else if (Integer.parseInt(subfields[0]) == 2) {
                        try {
                            dci = new ChartDciConfig();
                            dci.type = Integer.parseInt(subfields[0]);
                            dci.nodeId = Long.parseLong(subfields[1], 10);
                            dci.dciId = Long.parseLong(subfields[2], 10);
                            dci.name = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.dciName = URLDecoder.decode(subfields[3], "UTF-8");
                            dci.instance = URLDecoder.decode(subfields[4], "UTF-8");
                            dci.column = URLDecoder.decode(subfields[5], "UTF-8");
                            items.add(dci);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            if (items.size() == 1) {
                ChartDciConfig item = (ChartDciConfig)items.get(0);
                AbstractObject object = this.session.findObjectById(item.nodeId);
                if (object != null) {
                    this.setPartName(String.valueOf(object.getObjectName()) + ": " + item.name);
                }
            } else if (items.size() > 1) {
                AbstractObject object;
                long nodeId = ((ChartDciConfig)items.get((int)0)).nodeId;
                for (ChartDciConfig item : items) {
                    if (item.nodeId == nodeId) continue;
                    nodeId = -1L;
                    break;
                }
                if (nodeId != -1L && (object = this.session.findObjectById(nodeId)) != null) {
                    Messages.get();
                    this.setPartName(String.format(Messages.HistoricalGraphView_PartName, object.getObjectName()));
                }
            }
            this.configuration.setTitle(this.getPartName());
            this.configuration.setDciList(items.toArray(new ChartDciConfig[items.size()]));
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            long id;
            try {
                id = Long.parseLong(memento.getTextData());
                if (id == 0L) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Messages.get();
            ConsoleJob job = new ConsoleJob(Messages.HistoricalGraphView_JobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final GraphDefinition s = HistoricalGraphView.this.session.getPredefinedGraph(id);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).HistoricalGraphView.this.configuration = s;
                            HistoricalGraphView.this.configureGraphFromSettings();
                            (this).HistoricalGraphView.this.configuration.addChangeListener((ChartConfigurationChangeListener)HistoricalGraphView.this);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return null;
                }
            };
            job.setUser(false);
            job.start();
        }
    }

    public void saveState(IMemento memento) {
        try {
            memento.putTextData(Long.toString(this.configuration.getId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initPredefinedGraph(GraphDefinition definition) {
        this.configuration = new GraphDefinition(definition);
        this.configuration.addChangeListener((ChartConfigurationChangeListener)this);
        this.configureGraphFromSettings();
    }

    private void configureGraphFromSettings() {
        if (this.chart != null) {
            this.chart.dispose();
        }
        this.setPartName(this.configuration.getTitle());
        ChartConfiguration chartConfiguration = new ChartConfiguration((ChartConfiguration)this.configuration);
        chartConfiguration.setZoomEnabled(true);
        this.chart = new Chart(this.chartParent, 0, ChartType.LINE, chartConfiguration);
        this.createPopupMenu();
        int nodeId = 0;
        ChartDciConfig[] chartDciConfigArray = this.configuration.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            nodeId = (int)((long)nodeId | dci.nodeId);
            GraphItem item = new GraphItem(dci);
            if (this.configuration.isShowHostNames()) {
                item.setDescription(String.valueOf(this.session.getObjectName(dci.nodeId)) + " - " + dci.getLabel());
            }
            this.chart.addParameter(item);
            ++n2;
        }
        this.updateDciInfo();
        if (this.chart.getItemCount() > 1) {
            this.multipleSourceNodes = (long)nodeId != this.configuration.getDciList()[0].nodeId;
        }
        this.chart.rebuild();
        this.chartParent.layout(true, true);
        this.updateChart();
        this.actionAutoRefresh.setChecked(this.configuration.isAutoRefresh());
        this.refreshMenuSelection();
        this.refreshController.setInterval(this.configuration.isAutoRefresh() ? this.configuration.getRefreshRate() : -1);
    }

    private void updateDciInfo() {
        ConsoleJob job = new ConsoleJob("Get DCI info", (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map measurementUnits = HistoricalGraphView.this.session.getDciMeasurementUnits(HistoricalGraphView.this.configuration.getDciList());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        ChartDciConfig[] chartDciConfigArray = (this).HistoricalGraphView.this.configuration.getDciList();
                        int n = chartDciConfigArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ChartDciConfig dci = chartDciConfigArray[n2];
                            GraphItem item = (this).HistoricalGraphView.this.chart.getItem(i);
                            if (item != null) {
                                item.setMeasurementUnit((MeasurementUnit)measurementUnits.get(dci.getDciId()));
                            }
                            ++i;
                            ++n2;
                        }
                        (this).HistoricalGraphView.this.chart.rebuild();
                        (this).HistoricalGraphView.this.chartParent.layout(true, true);
                        HistoricalGraphView.this.updateChart();
                    }
                });
            }

            protected String getErrorMessage() {
                return null;
            }
        };
        job.setUser(false);
        job.start();
    }

    public void createPartControl(Composite parent) {
        this.chartParent = parent;
        this.createActions();
        this.contributeToActionBars();
        this.configureGraphFromSettings();
        this.configuration.addChangeListener((ChartConfigurationChangeListener)this);
    }

    private void createPopupMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HistoricalGraphView.this.fillContextMenu(mgr);
            }
        });
        this.chart.setMenuManager(menuManager);
    }

    private void getDataFromServer() {
        final ChartDciConfig[] dciList = this.configuration.getDciList();
        if (dciList.length == 0) {
            this.updateInProgress = false;
            return;
        }
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.HistoricalGraphView_JobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview"){
            private ChartDciConfig currentItem;

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(this.getName(), dciList.length);
                final DciData[] data = new DciData[dciList.length];
                final Threshold[][] thresholds = new Threshold[dciList.length][];
                int i = 0;
                while (i < dciList.length) {
                    this.currentItem = dciList[i];
                    if (this.currentItem.type == 1) {
                        data[i] = HistoricalGraphView.this.session.getCollectedData(this.currentItem.nodeId, this.currentItem.dciId, HistoricalGraphView.this.configuration.getTimeFrom(), HistoricalGraphView.this.configuration.getTimeTo(), 0, this.currentItem.useRawValues ? HistoricalDataType.RAW : HistoricalDataType.PROCESSED);
                        thresholds[i] = HistoricalGraphView.this.session.getThresholds(this.currentItem.nodeId, this.currentItem.dciId);
                    } else {
                        data[i] = HistoricalGraphView.this.session.getCollectedTableData(this.currentItem.nodeId, this.currentItem.dciId, this.currentItem.instance, this.currentItem.column, HistoricalGraphView.this.configuration.getTimeFrom(), HistoricalGraphView.this.configuration.getTimeTo(), 0);
                        thresholds[i] = null;
                    }
                    monitor.worked(1);
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).HistoricalGraphView.this.chart.isDisposed()) {
                            (this).HistoricalGraphView.this.chart.setTimeRange((this).HistoricalGraphView.this.configuration.getTimeFrom(), (this).HistoricalGraphView.this.configuration.getTimeTo());
                            HistoricalGraphView.this.setChartData(data, thresholds);
                            (this).HistoricalGraphView.this.chart.clearErrors();
                        }
                        (this).HistoricalGraphView.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.HistoricalGraphView_JobError, HistoricalGraphView.this.session.getObjectName(this.currentItem.nodeId), this.currentItem.name);
            }

            protected void jobFailureHandler() {
                HistoricalGraphView.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).HistoricalGraphView.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setFocus() {
        this.chart.setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                HistoricalGraphView.this.updateChart();
            }
        };
        Messages.get();
        this.actionProperties = new Action(Messages.HistoricalGraphView_Properties){

            public void run() {
                HistoricalGraphView.this.showGraphPropertyPages(HistoricalGraphView.this.configuration);
                HistoricalGraphView.this.configureGraphFromSettings();
            }
        };
        Messages.get();
        this.actionAutoRefresh = new Action(Messages.HistoricalGraphView_Autorefresh){

            public void run() {
                HistoricalGraphView.this.configuration.setAutoRefresh(!HistoricalGraphView.this.configuration.isAutoRefresh());
                this.setChecked(HistoricalGraphView.this.configuration.isAutoRefresh());
                HistoricalGraphView.this.refreshController.setInterval(HistoricalGraphView.this.configuration.isAutoRefresh() ? HistoricalGraphView.this.configuration.getRefreshRate() : -1);
            }
        };
        this.actionAutoRefresh.setChecked(this.configuration.isAutoRefresh());
        Messages.get();
        this.actionLogScale = new Action(Messages.HistoricalGraphView_LogScale){

            public void run() {
                try {
                    HistoricalGraphView.this.configuration.setLogScale(!HistoricalGraphView.this.configuration.isLogScale());
                    HistoricalGraphView.this.chart.getConfiguration().setLogScale(HistoricalGraphView.this.configuration.isLogScale());
                    HistoricalGraphView.this.chart.rebuild();
                }
                catch (IllegalStateException e) {
                    Shell shell = HistoricalGraphView.this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.HistoricalGraphView_Error, (String)String.format(Messages.HistoricalGraphView_LogScaleSwitchError, e.getLocalizedMessage()));
                    Activator.logError("Cannot change log scale mode", e);
                }
                this.setChecked(HistoricalGraphView.this.configuration.isLogScale());
            }
        };
        this.actionLogScale.setChecked(this.configuration.isLogScale());
        Messages.get();
        this.actionZoomIn = new Action(Messages.HistoricalGraphView_ZoomIn){

            public void run() {
                HistoricalGraphView.this.chart.zoomIn();
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        Messages.get();
        this.actionZoomOut = new Action(Messages.HistoricalGraphView_ZoomOut){

            public void run() {
                HistoricalGraphView.this.chart.zoomOut();
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        HistoricalChartOwner chartOwner = new HistoricalChartOwner(){

            @Override
            public Chart getChart() {
                return HistoricalGraphView.this.chart;
            }
        };
        this.actionAdjustX = HistoricalGraphView.createAction(ChartActionType.ADJUST_X, chartOwner);
        this.actionAdjustY = HistoricalGraphView.createAction(ChartActionType.ADJUST_Y, chartOwner);
        this.actionAdjustBoth = HistoricalGraphView.createAction(ChartActionType.ADJUST_BOTH, chartOwner);
        Messages.get();
        this.actionShowLegend = new Action(Messages.HistoricalGraphView_ShowLegend){

            public void run() {
                HistoricalGraphView.this.configuration.setLegendVisible(HistoricalGraphView.this.actionShowLegend.isChecked());
                HistoricalGraphView.this.chart.getConfiguration().setLegendVisible(HistoricalGraphView.this.configuration.isLegendVisible());
                HistoricalGraphView.this.chart.rebuild();
            }
        };
        this.actionShowLegend.setChecked(this.configuration.isLegendVisible());
        Messages.get();
        this.actionExtendedLegend = new Action(Messages.HistoricalGraphView_ExtendedLegend){

            public void run() {
                HistoricalGraphView.this.configuration.setExtendedLegend(HistoricalGraphView.this.actionExtendedLegend.isChecked());
                HistoricalGraphView.this.chart.getConfiguration().setExtendedLegend(HistoricalGraphView.this.configuration.isExtendedLegend());
                HistoricalGraphView.this.chart.rebuild();
            }
        };
        this.actionExtendedLegend.setChecked(this.configuration.isExtendedLegend());
        Messages.get();
        this.actionLegendLeft = new Action(Messages.HistoricalGraphView_PlaceOnLeft, 8){

            public void run() {
                HistoricalGraphView.this.configuration.setLegendPosition(1);
                HistoricalGraphView.this.chart.getConfiguration().setLegendPosition(HistoricalGraphView.this.configuration.getLegendPosition());
                HistoricalGraphView.this.chart.rebuild();
            }
        };
        this.actionLegendLeft.setChecked(this.configuration.getLegendPosition() == 1);
        Messages.get();
        this.actionLegendRight = new Action(Messages.HistoricalGraphView_PlaceOnRight, 8){

            public void run() {
                HistoricalGraphView.this.configuration.setLegendPosition(2);
                HistoricalGraphView.this.chart.getConfiguration().setLegendPosition(HistoricalGraphView.this.configuration.getLegendPosition());
                HistoricalGraphView.this.chart.rebuild();
            }
        };
        this.actionLegendRight.setChecked(this.configuration.getLegendPosition() == 2);
        Messages.get();
        this.actionLegendTop = new Action(Messages.HistoricalGraphView_PlaceOnTop, 8){

            public void run() {
                HistoricalGraphView.this.configuration.setLegendPosition(4);
                HistoricalGraphView.this.chart.getConfiguration().setLegendPosition(HistoricalGraphView.this.configuration.getLegendPosition());
                HistoricalGraphView.this.chart.rebuild();
            }
        };
        this.actionLegendTop.setChecked(this.configuration.getLegendPosition() == 4);
        Messages.get();
        this.actionLegendBottom = new Action(Messages.HistoricalGraphView_PlaceOnBottom, 8){

            public void run() {
                HistoricalGraphView.this.configuration.setLegendPosition(8);
                HistoricalGraphView.this.chart.getConfiguration().setLegendPosition(HistoricalGraphView.this.configuration.getLegendPosition());
                HistoricalGraphView.this.chart.rebuild();
            }
        };
        this.actionLegendBottom.setChecked(this.configuration.getLegendPosition() == 8);
        this.actionSave = new Action("Save", SharedIcons.SAVE){

            public void run() {
                if (HistoricalGraphView.this.configuration.getId() == 0L) {
                    String initalName = HistoricalGraphView.this.configuration.getName().compareTo("noname") == 0 ? HistoricalGraphView.this.configuration.getTitle() : HistoricalGraphView.this.configuration.getName();
                    HistoricalGraphView.this.saveGraph(initalName, null, false, false, true);
                } else {
                    HistoricalGraphView.this.saveGraph(HistoricalGraphView.this.configuration.getName(), null, false, false, false);
                }
            }
        };
        this.actionSaveAs = new Action("Save as...", SharedIcons.SAVE_AS){

            public void run() {
                String initalName = HistoricalGraphView.this.configuration.getName().compareTo("noname") == 0 ? HistoricalGraphView.this.configuration.getTitle() : HistoricalGraphView.this.configuration.getName();
                HistoricalGraphView.this.saveGraph(initalName, null, false, false, true);
            }
        };
        this.actionSaveAsTemplate = new Action("Save as template"){

            public void run() {
                String initalName = HistoricalGraphView.this.configuration.getName().compareTo("noname") == 0 ? HistoricalGraphView.this.configuration.getTitle() : HistoricalGraphView.this.configuration.getName();
                HistoricalGraphView.this.saveGraph(initalName, null, false, true, true);
            }
        };
        Messages.get();
        this.actionStacked = new Action(Messages.HistoricalGraphView_Stacked, 2){

            public void run() {
                HistoricalGraphView.this.configuration.setStacked(HistoricalGraphView.this.actionStacked.isChecked());
                HistoricalGraphView.this.configureGraphFromSettings();
            }
        };
        this.actionStacked.setChecked(this.configuration.isStacked());
        Messages.get();
        this.actionTranslucent = new Action(Messages.HistoricalGraphView_Translucent, 2){

            public void run() {
                HistoricalGraphView.this.configuration.setTranslucent(HistoricalGraphView.this.actionTranslucent.isChecked());
                HistoricalGraphView.this.configureGraphFromSettings();
            }
        };
        this.actionTranslucent.setChecked(this.configuration.isTranslucent());
        this.actionAreaChart = new Action("Area chart", 2){

            public void run() {
                HistoricalGraphView.this.configuration.setArea(HistoricalGraphView.this.actionAreaChart.isChecked());
                HistoricalGraphView.this.configureGraphFromSettings();
            }
        };
        this.actionAreaChart.setChecked(this.configuration.isArea());
        this.presetActions = HistoricalGraphView.createPresetActions(new PresetHandler(){

            @Override
            public void onPresetSelected(TimeUnit unit, int range) {
                HistoricalGraphView.this.configuration.getTimePeriod().setTimeUnit(unit);
                HistoricalGraphView.this.configuration.getTimePeriod().setTimeRange(range);
                HistoricalGraphView.this.updateChart();
            }
        });
        Messages.get();
        this.actionCopyImage = new Action(Messages.HistoricalGraphView_CopyToClipboard, SharedIcons.COPY){

            public void run() {
                HistoricalGraphView.this.chart.copyToClipboard();
            }
        };
        this.actionSaveAsImage = new Action("Save as image...", SharedIcons.SAVE_AS_IMAGE){

            public void run() {
                HistoricalGraphView.this.chart.saveAsImage(HistoricalGraphView.this.getSite().getShell());
            }
        };
    }

    protected void refreshMenuSelection() {
        this.actionAutoRefresh.setChecked(this.configuration.isAutoRefresh());
        this.actionLogScale.setChecked(this.configuration.isLogScale());
        this.actionShowLegend.setChecked(this.configuration.isLegendVisible());
        this.actionExtendedLegend.setChecked(this.configuration.isExtendedLegend());
        this.actionStacked.setChecked(this.configuration.isStacked());
        this.actionTranslucent.setChecked(this.configuration.isTranslucent());
        this.actionAreaChart.setChecked(this.configuration.isArea());
        this.actionLegendLeft.setChecked(this.configuration.getLegendPosition() == 1);
        this.actionLegendRight.setChecked(this.configuration.getLegendPosition() == 2);
        this.actionLegendTop.setChecked(this.configuration.getLegendPosition() == 4);
        this.actionLegendBottom.setChecked(this.configuration.getLegendPosition() == 8);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        Messages.get();
        MenuManager presets = new MenuManager(Messages.HistoricalGraphView_Presets);
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        Messages.get();
        MenuManager legend = new MenuManager(Messages.HistoricalGraphView_Legend);
        legend.add((IAction)this.actionShowLegend);
        legend.add((IAction)this.actionExtendedLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAreaChart);
        manager.add((IAction)this.actionStacked);
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionTranslucent);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionSaveAsTemplate);
        manager.add((IAction)this.actionProperties);
    }

    private void fillContextMenu(IMenuManager manager) {
        Messages.get();
        MenuManager presets = new MenuManager(Messages.HistoricalGraphView_Presets);
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        Messages.get();
        MenuManager legend = new MenuManager(Messages.HistoricalGraphView_Legend);
        legend.add((IAction)this.actionShowLegend);
        legend.add((IAction)this.actionExtendedLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAreaChart);
        manager.add((IAction)this.actionStacked);
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionTranslucent);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperties);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionCopyImage);
        manager.add((IAction)this.actionSaveAsImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void setChartData(DciData[] data, Threshold[][] thresholds) {
        int i = 0;
        while (i < data.length) {
            this.chart.updateParameter(i, data[i], false);
            ++i;
        }
        this.chart.setThresholds(thresholds);
        this.chart.refresh();
    }

    private void updateChart() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        if (this.configuration.getTimePeriod().isBackFromNow()) {
            this.configuration.setTimeFrom(new Date(System.currentTimeMillis() - this.configuration.getTimeRangeMillis()));
            this.configuration.setTimeTo(new Date(System.currentTimeMillis()));
        }
        this.getDataFromServer();
    }

    public void dispose() {
        this.refreshController.dispose();
        super.dispose();
    }

    public void onChartConfigurationChange(ChartConfiguration settings) {
        if (this.configuration == settings) {
            this.configureGraphFromSettings();
        }
    }

    private void saveGraph(String graphName, String errorMessage, final boolean canBeOverwritten, final boolean asTemplate, boolean showNameDialog) {
        GraphDefinition gs;
        SaveGraphDlg dlg;
        if (asTemplate && this.multipleSourceNodes) {
            String templateError = "More than one node is used for template creation.\nThis may cause undefined behaviour.";
            errorMessage = errorMessage == null ? templateError : String.valueOf(errorMessage) + "\n\n" + templateError;
        }
        int result = 0;
        GraphDefinition template = null;
        final long oldGraphId = this.configuration.getId();
        if (asTemplate) {
            dlg = new SaveGraphDlg(this.getSite().getShell(), graphName, errorMessage, canBeOverwritten);
            result = dlg.open();
            if (result == 1) {
                return;
            }
            template = new GraphDefinition(this.configuration);
            template.setId(0L);
            template.setOwnerId((long)this.session.getUserId());
            template.setAccessList(new ArrayList(0));
            template.setName(dlg.getName());
            template.setFlags(1);
        } else if (showNameDialog) {
            dlg = new SaveGraphDlg(this.getSite().getShell(), graphName, errorMessage, canBeOverwritten);
            result = dlg.open();
            if (result == 1) {
                return;
            }
            this.configuration.setName(dlg.getName());
            if (!canBeOverwritten) {
                this.configuration.setId(0L);
            }
        } else {
            this.configuration.setName(graphName);
        }
        GraphDefinition graphDefinition = gs = asTemplate ? template : this.configuration;
        if (result == 101) {
            Messages.get();
            new ConsoleJob(Messages.HistoricalGraphView_SaveSettings, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long id = HistoricalGraphView.this.session.saveGraph(gs, canBeOverwritten);
                    if (!asTemplate) {
                        HistoricalGraphView.this.configuration.setId(id);
                    }
                }

                protected String getErrorMessage() {
                    HistoricalGraphView.this.configuration.setId(oldGraphId);
                    Messages.get();
                    return Messages.HistoricalGraphView_SaveSettingsError;
                }
            }.start();
        } else {
            Messages.get();
            new ConsoleJob(Messages.HistoricalGraphView_SaveSettings, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    try {
                        long id = HistoricalGraphView.this.session.saveGraph(gs, canBeOverwritten);
                        if (!asTemplate) {
                            HistoricalGraphView.this.configuration.setId(id);
                        }
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 107) {
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    (this).HistoricalGraphView.this.configuration.setId(oldGraphId);
                                    HistoricalGraphView historicalGraphView = HistoricalGraphView.this;
                                    String string = gs.getName();
                                    Messages.get();
                                    historicalGraphView.saveGraph(string, Messages.HistoricalGraphView_NameAlreadyExist, true, asTemplate, true);
                                }
                            });
                        }
                        if (e.getErrorCode() == 2) {
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    (this).HistoricalGraphView.this.configuration.setId(oldGraphId);
                                    HistoricalGraphView historicalGraphView = HistoricalGraphView.this;
                                    String string = gs.getName();
                                    Messages.get();
                                    historicalGraphView.saveGraph(string, Messages.HistoricalGraphView_NameAlreadyExistNoOverwrite, false, asTemplate, true);
                                }
                            });
                        }
                        HistoricalGraphView.this.configuration.setId(oldGraphId);
                        throw e;
                    }
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.HistoricalGraphView_SaveError;
                }
            }.start();
        }
    }

    public static Action[] createPresetActions(final PresetHandler handler) {
        Action[] actions = new Action[presetRanges.length];
        int i = 0;
        while (i < presetRanges.length) {
            final Integer presetIndex = i;
            Messages.get();
            actions[i] = new Action(String.format(Messages.HistoricalGraphView_Last, presetNames[i])){

                public void run() {
                    handler.onPresetSelected(presetUnits[presetIndex], presetRanges[presetIndex]);
                }
            };
            ++i;
        }
        return actions;
    }

    public static Action createAction(ChartActionType type, final HistoricalChartOwner chartOwner) {
        Action action = null;
        switch (type) {
            case ADJUST_BOTH: {
                action = new Action(){

                    public void run() {
                        chartOwner.getChart().adjustXAxis(false);
                        chartOwner.getChart().adjustYAxis(true);
                    }
                };
                Messages.get();
                action.setText(Messages.HistoricalGraphView_Adjust);
                action.setImageDescriptor(Activator.getImageDescriptor("icons/adjust.png"));
                break;
            }
            case ADJUST_X: {
                action = new Action(){

                    public void run() {
                        chartOwner.getChart().adjustXAxis(true);
                    }
                };
                Messages.get();
                action.setText(Messages.HistoricalGraphView_AdjustX);
                action.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_x.png"));
                break;
            }
            case ADJUST_Y: {
                action = new Action(){

                    public void run() {
                        chartOwner.getChart().adjustYAxis(true);
                    }
                };
                Messages.get();
                action.setText(Messages.HistoricalGraphView_AdjustY);
                action.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_y.png"));
            }
        }
        return action;
    }

    private boolean showGraphPropertyPages(final GraphDefinition settings) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("graph", (IPreferencePage)new Graph(settings, false)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General((ChartConfiguration)settings, false)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("source", (IPreferencePage)new DataSources(settings, false)));
        PreferenceDialog dlg = new PreferenceDialog(this.getViewSite().getShell(), pm){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Properties for " + settings.getDisplayName());
            }
        };
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    public static enum ChartActionType {
        ADJUST_X,
        ADJUST_Y,
        ADJUST_BOTH;

    }

    public static interface HistoricalChartOwner {
        public Chart getChart();
    }

    public static interface PresetHandler {
        public void onPresetSelected(TimeUnit var1, int var2);
    }
}

