/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfigFactory;
import org.netxms.nxmc.modules.objects.actions.ObjectAction;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ExportDashboardAction
extends ObjectAction<Dashboard> {
    private final I18n i18n = LocalizationHelper.getI18n(ExportDashboardAction.class);

    public ExportDashboardAction(ViewPlacement viewPlacement, ISelectionProvider selectionProvider) {
        super(Dashboard.class, LocalizationHelper.getI18n(ExportDashboardAction.class).tr("&Export..."), viewPlacement, selectionProvider);
        this.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/export.png"));
    }

    protected void run(List<Dashboard> selection) {
        Dashboard dashboard = selection.get(0);
        HashSet objects = new HashSet();
        HashMap items = new HashMap();
        StringBuilder xml = new StringBuilder("<dashboard>\n\t<name>");
        xml.append(dashboard.getObjectName());
        xml.append("</name>\n\t<columns>");
        xml.append(dashboard.getNumColumns());
        xml.append("</columns>\n\t<flags>");
        xml.append(dashboard.getFlags());
        xml.append("</flags>\n\t<autoBindFlags>");
        xml.append(dashboard.getAutoBindFlags());
        xml.append("</autoBindFlags>\n\t<autoBindFilter>");
        xml.append(dashboard.getAutoBindFilter().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        xml.append("</autoBindFilter>\n\t<elements>\n");
        for (DashboardElement e : dashboard.getElements()) {
            xml.append("\t\t<dashboardElement>\n\t\t\t<type>");
            xml.append(e.getType());
            xml.append("</type>\n");
            xml.append(e.getLayout());
            xml.append('\n');
            xml.append(e.getData());
            xml.append("\n\t\t</dashboardElement>\n");
            DashboardElementConfig config = DashboardElementConfigFactory.create((DashboardElement)e);
            if (config == null) continue;
            objects.addAll(config.getObjects());
            items.putAll(config.getDataCollectionItems());
        }
        xml.append("\t</elements>\n");
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForSelection(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof Dashboard;
    }
}

