/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.propertypages;

import java.util.HashMap;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.views.helpers.BaseUserLabelProvider;
import org.xnap.commons.i18n.I18n;

public class GroupMembership
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(GroupMembership.class);
    private TableViewer groupList;
    private NXCSession session;
    private User object;
    private HashMap<Integer, AbstractUserObject> groups = new HashMap(0);

    public GroupMembership(User user, MessageAreaHolder messageArea) {
        super(LocalizationHelper.getI18n(GroupMembership.class).tr("Group Membership"), messageArea);
        this.session = Registry.getSession();
        this.object = user;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.groupList = new TableViewer(dialogArea, 67586);
        this.groupList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.groupList.setLabelProvider((IBaseLabelProvider)new BaseUserLabelProvider());
        this.groupList.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.groupList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(this.i18n.tr("&Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(this.i18n.tr("&Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.groupList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        for (int groupId : this.object.getGroups()) {
            AbstractUserObject group = this.session.findUserDBObjectById(groupId, null);
            if (group == null) continue;
            this.groups.put(group.getId(), group);
        }
        AbstractUserObject group = this.session.findUserDBObjectById(0x40000000, null);
        if (group != null) {
            this.groups.put(group.getId(), group);
        }
        this.groupList.setInput((Object)this.groups.values().toArray());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setMessage(null);
            this.setValid(false);
        }
        int[] groupIds = new int[this.groups.size()];
        int i = 0;
        for (Integer id : this.groups.keySet()) {
            groupIds[i++] = id;
        }
        this.object.setGroups(groupIds);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

