/*
 * Decompiled with CFR 0.152.
 */
package org.netxms;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.netxms.base.VersionInfo;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.util.InteractiveConsole;

public class Shell {
    private static final String DEFAULT_SERVER = "127.0.0.1";
    private static final String DEFAULT_LOGIN = "admin";
    private Properties configuration = new Properties();
    private String optServer;
    private String optPort;
    private String optLogin;
    private String optPassword;
    private String optToken;

    public static void main(String[] args) {
        Shell shell = new Shell();
        try {
            shell.configuration.putAll((Map<?, ?>)System.getProperties());
            shell.configuration.putAll((Map<?, ?>)Shell.loadProperties("nxshell.properties"));
            String customPropertyFile = shell.configuration.getProperty("nxshell.properties");
            if (customPropertyFile != null) {
                shell.configuration.putAll((Map<?, ?>)Shell.loadProperties(customPropertyFile));
            }
            shell.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void run(String[] args) throws IOException, NXCException {
        this.initJython(args);
        this.readCredentials(args.length == 0 && this.isInteractive());
        NXCSession session = this.connect();
        InteractiveConsole console = this.createInterpreter(args);
        console.set("session", session);
        console.set("s", session);
        if (args.length == 0) {
            console.interact(this.getBanner(), null);
        } else {
            console.execfile(args[0]);
        }
        console.cleanup();
        session.disconnect();
    }

    private void readCredentials(boolean interactive) {
        this.optServer = this.configuration.getProperty("netxms.server");
        this.optPort = this.configuration.getProperty("netxms.port");
        this.optLogin = this.configuration.getProperty("netxms.login");
        this.optPassword = this.configuration.getProperty("netxms.password");
        this.optToken = this.configuration.getProperty("netxms.token");
        if (interactive) {
            Console console = System.console();
            if (this.optServer == null) {
                this.optServer = console.readLine("Server IP [127.0.0.1]: ", new Object[0]);
                if (this.optPort == null) {
                    this.optPort = console.readLine("Server TCP port [4701]: ", new Object[0]);
                }
            }
            if (this.optLogin == null && this.optToken == null) {
                this.optLogin = console.readLine("Login [admin]: ", new Object[0]);
            }
            if (this.optPassword == null && this.optToken == null) {
                char[] passwordChars = console.readPassword("Password: ", new Object[0]);
                this.optPassword = passwordChars == null ? "" : new String(passwordChars);
            }
        }
        if (this.optServer == null || this.optServer.length() == 0) {
            this.optServer = DEFAULT_SERVER;
        }
        if (this.optLogin == null || this.optLogin.length() == 0) {
            this.optLogin = DEFAULT_LOGIN;
        }
        if (this.optPassword == null) {
            this.optPassword = "";
        }
    }

    private String getBanner() {
        return "NetXMS " + VersionInfo.version() + " Interactive Shell";
    }

    private NXCSession connect() throws IOException, NXCException {
        String hostName;
        boolean enableCompression = true;
        String enableCompressionOption = this.configuration.getProperty("netxms.enableCompression");
        if (enableCompressionOption != null) {
            enableCompression = Boolean.parseBoolean(enableCompressionOption);
        }
        boolean sync = true;
        String syncOption = this.configuration.getProperty("netxms.syncObjects");
        if (syncOption != null) {
            sync = Boolean.parseBoolean(syncOption);
        }
        int port = 4701;
        if (this.optPort != null && !this.optPort.isEmpty()) {
            hostName = this.optServer;
            try {
                port = Integer.valueOf(this.optPort);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String[] parts = this.optServer.split(":");
            if (parts.length == 2) {
                hostName = parts[0];
                try {
                    port = Integer.valueOf(parts[1]);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                hostName = this.optServer;
            }
        }
        NXCSession session = new NXCSession(hostName, port, enableCompression);
        session.connect();
        if (this.optToken != null) {
            session.login(this.optToken);
        } else {
            session.login(this.optLogin, this.optPassword);
        }
        if (sync) {
            session.syncObjects();
            session.syncUserDatabase();
        }
        return session;
    }

    protected boolean isInteractive() {
        PySystemState systemState = Py.getSystemState();
        boolean interactive = ((PyFile)Py.defaultSystemState.stdin).isatty();
        if (!interactive) {
            systemState.ps1 = systemState.ps2 = Py.EmptyString;
        }
        return interactive;
    }

    private InteractiveConsole createInterpreter(String[] args) {
        PySystemState systemState = Py.getSystemState();
        if (!this.isInteractive()) {
            systemState.ps1 = systemState.ps2 = Py.EmptyString;
        }
        InteractiveConsole console = new InteractiveConsole();
        Py.getSystemState().__setattr__("_jy_interpreter", Py.java2py(console));
        imp.load("site");
        console.exec("from org.netxms.base import *");
        console.exec("from org.netxms.client import *");
        console.exec("from org.netxms.client.agent.config import *");
        console.exec("from org.netxms.client.asset import *");
        console.exec("from org.netxms.client.businessservices import *");
        console.exec("from org.netxms.client.constants import *");
        console.exec("from org.netxms.client.dashboards import *");
        console.exec("from org.netxms.client.datacollection import *");
        console.exec("from org.netxms.client.events import *");
        console.exec("from org.netxms.client.log import *");
        console.exec("from org.netxms.client.maps import *");
        console.exec("from org.netxms.client.maps.configs import *");
        console.exec("from org.netxms.client.maps.elements import *");
        console.exec("from org.netxms.client.mt import *");
        console.exec("from org.netxms.client.objects import *");
        console.exec("from org.netxms.client.objects.configs import *");
        console.exec("from org.netxms.client.objects.interfaces import *");
        console.exec("from org.netxms.client.objects.queries import *");
        console.exec("from org.netxms.client.objecttools import *");
        console.exec("from org.netxms.client.packages import *");
        console.exec("from org.netxms.client.reporting import *");
        console.exec("from org.netxms.client.search import *");
        console.exec("from org.netxms.client.server import *");
        console.exec("from org.netxms.client.services import *");
        console.exec("from org.netxms.client.snmp import *");
        console.exec("from org.netxms.client.topology import *");
        console.exec("from org.netxms.client.users import *");
        console.exec("from org.netxms.client.xml import *");
        console.set("__name__", "__nxshell__");
        return console;
    }

    private void initJython(String[] args) {
        Properties postProperties = new Properties();
        File tempDirectory = new File(this.configuration.getProperty("java.io.tmpdir"));
        File cacheDir = new File(tempDirectory, "nxshell");
        postProperties.setProperty("python.cachedir", cacheDir.getPath());
        postProperties.setProperty("python.cachedir.skip", "false");
        PySystemState.initialize(PySystemState.getBaseProperties(), postProperties, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String name) {
        ClassLoader classLoader = Shell.class.getClassLoader();
        Properties properties = new Properties();
        InputStream stream = null;
        try {
            File f;
            stream = classLoader.getResourceAsStream(name);
            if (stream == null && (f = new File(name)).isFile()) {
                stream = new FileInputStream(f);
            }
            if (stream != null) {
                properties.load(stream);
            }
        }
        catch (Exception e) {
            System.err.println("Error loading properties file " + name);
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

