/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.websvc.ApiProperties;
import org.netxms.websvc.SessionToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStore {
    private static ApiProperties properties = new ApiProperties();
    private Map<UUID, SessionToken> sessions = new HashMap();
    private Logger log = LoggerFactory.getLogger(SessionStore.class);
    private Thread sessionManager = null;

    public static synchronized SessionStore getInstance(ServletContext context) {
        SessionStore s = (SessionStore)context.getAttribute("org.netxms.webui.sessionStore");
        if (s == null) {
            s = new SessionStore();
            context.setAttribute("org.netxms.webui.sessionStore", (Object)s);
        }
        return s;
    }

    public synchronized SessionToken getSessionToken(UUID guid) {
        SessionToken s = (SessionToken)this.sessions.get(guid);
        if (s != null) {
            s.updateActivityTimestamp();
        }
        return s;
    }

    public synchronized SessionToken registerSession(NXCSession session) {
        if (this.sessionManager == null) {
            this.sessionManager = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "Session Manager");
            this.sessionManager.setDaemon(true);
            this.sessionManager.start();
        }
        SessionToken token = new SessionToken(session);
        this.sessions.put(token.getSessionHandle(), token);
        session.addListener((SessionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.log.info("Session " + String.valueOf(token.getSessionHandle()) + " registered");
        return token;
    }

    public synchronized void unregisterSession(UUID guid) {
        this.sessions.remove(guid);
        this.log.info("Session " + String.valueOf(guid) + " unregistered");
    }

    private void sessionManagerThread() {
        while (true) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkSessions();
        }
    }

    private synchronized void checkSessions() {
        long now = System.currentTimeMillis();
        ArrayList<UUID> disconnectedSessions = new ArrayList<UUID>();
        for (SessionToken s : this.sessions.values()) {
            if (now - s.getActivityTimestamp() > properties.getSessionTimeout()) {
                this.log.info("Session " + String.valueOf(s.getSessionHandle()) + " disconnected by inactivity timeout");
                s.getSession().disconnect();
                disconnectedSessions.add(s.getSessionHandle());
                continue;
            }
            if (s.getSession().checkConnection()) continue;
            this.log.info("Session " + String.valueOf(s.getSessionHandle()) + " removed due to communication failure");
            s.getSession().disconnect();
            disconnectedSessions.add(s.getSessionHandle());
        }
        for (UUID u : disconnectedSessions) {
            this.unregisterSession(u);
        }
    }
}

