/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.TableRow;
import org.netxms.client.datacollection.DciLastValue;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.json.JsonTools;

public class DCObjectLastValue
extends AbstractObjectHandler {
    protected Object get(String id, Map<String, String> query) throws Exception {
        DciLastValue value = this.getSession().getDciLastValue(this.getObjectId(), Long.parseLong(id));
        if (value.getDciType() != 2) {
            return value;
        }
        JsonObject result = new JsonObject();
        result.addProperty("dciType", (Number)value.getDciType());
        result.addProperty("dataOrigin", value.getDataOrigin().toString());
        result.addProperty("timestamp", (Number)value.getTimestamp().getTime());
        JsonObject tableValue = new JsonObject();
        result.add("tableValue", (JsonElement)tableValue);
        Gson gson = JsonTools.createGsonInstance();
        TableColumnDefinition[] columns = value.getTableValue().getColumns();
        tableValue.add("columns", gson.toJsonTree((Object)columns));
        JsonArray rows = new JsonArray();
        tableValue.add("data", (JsonElement)rows);
        if (Boolean.parseBoolean(query.getOrDefault("rowsAsObjects", "false"))) {
            for (TableRow r : value.getTableValue().getAllRows()) {
                JsonObject row = new JsonObject();
                for (int i = 0; i < columns.length; ++i) {
                    row.addProperty(columns[i].getName(), r.getValue(i));
                }
                rows.add((JsonElement)row);
            }
        } else {
            for (TableRow r : value.getTableValue().getAllRows()) {
                JsonArray row = new JsonArray();
                for (int i = 0; i < columns.length; ++i) {
                    row.add(r.getValue(i));
                }
                rows.add((JsonElement)row);
            }
        }
        return result;
    }
}

