/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.constants.AggregationFunction;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.client.objects.AbstractObject;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.json.JsonTools;
import org.netxms.websvc.json.ResponseContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryTableAdHoc
extends AbstractHandler {
    private Logger log = LoggerFactory.getLogger(AbstractHandler.class);

    protected Object create(JSONObject data) throws Exception {
        long baseObjectId;
        NXCSession session = this.getSession();
        if (!session.areObjectsSynchronized()) {
            session.syncObjects();
        }
        String objectFilter = JsonTools.getStringFromJson((JSONObject)data, (String)"baseObject", null);
        this.log.debug("POST adhoc summaryTable: baseObject = " + objectFilter);
        JSONArray columnDefinitions = JsonTools.getJsonArrayFromJson((JSONObject)data, (String)"columns", null);
        if (objectFilter == null || objectFilter.isEmpty() || columnDefinitions == null) {
            this.log.warn("POST adhoc summaryTable: no DciSummaryTableColumn table or no value for BaseObject");
            return this.createErrorResponse(12);
        }
        try {
            baseObjectId = Long.parseLong(objectFilter);
        }
        catch (NumberFormatException ex) {
            AbstractObject object = session.findObjectByName(objectFilter);
            baseObjectId = object != null ? object.getObjectId() : 0L;
        }
        ArrayList<DciSummaryTableColumn> columns = new ArrayList<DciSummaryTableColumn>();
        for (int i = 0; i < columnDefinitions.length(); ++i) {
            JSONObject columnDefinition = columnDefinitions.getJSONObject(i);
            int flags = 0;
            if (JsonTools.getBooleanFromJson((JSONObject)columnDefinition, (String)"isRegexp", (boolean)false) || JsonTools.getBooleanFromJson((JSONObject)columnDefinition, (String)"useRegexp", (boolean)false)) {
                flags |= DciSummaryTableColumn.REGEXP_MATCH;
            }
            if (JsonTools.getBooleanFromJson((JSONObject)columnDefinition, (String)"matchByDescription", (boolean)false)) {
                flags |= DciSummaryTableColumn.DESCRIPTION_MATCH;
            }
            columns.add(new DciSummaryTableColumn(JsonTools.getStringFromJson((JSONObject)columnDefinition, (String)"columnName", (String)""), JsonTools.getStringFromJson((JSONObject)columnDefinition, (String)"dciName", (String)""), flags));
        }
        AggregationFunction agrFunc = (AggregationFunction)JsonTools.getEnumFromJson((JSONObject)data, AggregationFunction.class, (String)"aggregationFunction", null);
        long date = JsonTools.getLongFromJson((JSONObject)data, (String)"startDate", (long)-1L);
        Date startDate = date > 0L ? new Date(date * 1000L) : null;
        date = JsonTools.getLongFromJson((JSONObject)data, (String)"endDate", (long)-1L);
        Date endDate = date > 0L ? new Date(date * 1000L) : null;
        boolean multiInstance = JsonTools.getBooleanFromJson((JSONObject)data, (String)"multiInstance", (boolean)true);
        Table table = session.queryAdHocDciSummaryTable(baseObjectId, columns, agrFunc, startDate, endDate, multiInstance);
        JSONObject root = new JSONObject();
        JSONArray resultColumns = new JSONArray();
        JSONArray resultRows = new JSONArray();
        String[] names = table.getColumnDisplayNames();
        for (int i = 0; i < names.length; ++i) {
            resultColumns.put((Object)names[i]);
        }
        root.put("columns", (Object)resultColumns);
        TableRow[] rows = table.getAllRows();
        for (int i = 0; i < rows.length; ++i) {
            JSONArray row = new JSONArray();
            for (int j = 0; j < rows[i].size(); ++j) {
                row.put((Object)rows[i].get(j).getValue());
            }
            resultRows.put((Object)row);
        }
        root.put("rows", (Object)resultRows);
        return new ResponseContainer("table", (Object)root);
    }
}

