/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.TableRow;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.json.ResponseContainer;

/*
 * Exception performing whole class analysis ignored.
 */
public class HistoricalData
extends AbstractObjectHandler {
    protected Object get(String id, Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        AbstractObject object = this.getObject();
        long dciId = 0L;
        try {
            dciId = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            dciId = session.dciNameToId(object.getObjectId(), id);
        }
        if (object == null || dciId == 0L || !(object instanceof DataCollectionTarget)) {
            throw new NXCException(7);
        }
        String timeFrom = query.get("from");
        String timeTo = query.get("to");
        String timeInterval = query.get("timeInterval");
        String itemCount = query.get("itemCount");
        DciData data = null;
        DataCollectionConfiguration dataCollectionConfiguration = session.openDataCollectionConfiguration(this.getObjectId());
        DataCollectionObject dataCollectionObject = dataCollectionConfiguration.findItem(dciId);
        HistoricalDataType valueType = HistoricalDataType.PROCESSED;
        if (dataCollectionObject instanceof DataCollectionTable) {
            valueType = HistoricalDataType.FULL_TABLE;
        }
        if (timeFrom != null || timeTo != null) {
            data = session.getCollectedData(object.getObjectId(), dciId, new Date(HistoricalData.parseLong((String)timeFrom, (long)0L) * 1000L), new Date(HistoricalData.parseLong((String)timeTo, (long)(System.currentTimeMillis() / 1000L)) * 1000L), HistoricalData.parseInt((String)itemCount, (int)0), valueType);
        } else if (timeInterval != null) {
            Date now = new Date();
            long from = now.getTime() - HistoricalData.parseLong((String)timeInterval, (long)0L) * 1000L;
            data = session.getCollectedData(object.getObjectId(), dciId, new Date(from), new Date(), HistoricalData.parseInt((String)itemCount, (int)0), valueType);
        } else if (itemCount != null) {
            data = session.getCollectedData(object.getObjectId(), dciId, null, null, HistoricalData.parseInt((String)itemCount, (int)0), valueType);
        } else {
            Date now = new Date();
            long from = now.getTime() - 3600000L;
            data = session.getCollectedData(object.getObjectId(), dciId, new Date(from), now, HistoricalData.parseInt((String)itemCount, (int)0), valueType);
        }
        return dataCollectionObject instanceof DataCollectionTable ? this.transformTableDataOutput(data, query.get("outputFormat")) : data;
    }

    private Object transformTableDataOutput(DciData data, String outputFormat) throws Exception {
        Object outputData;
        HashMap<String, Object> response = new HashMap<String, Object>();
        DciDataRow[] tableValues = data.getValues();
        Table firstTable = (Table)tableValues[0].getValue();
        response.put("nodeId", data.getNodeId());
        response.put("dciId", data.getDciId());
        response.put("source", firstTable.getSource());
        response.put("title", firstTable.getTitle());
        response.put("columns", firstTable.getColumns());
        ArrayList<Integer> instanceColumns = new ArrayList<Integer>();
        for (int i = 0; i < firstTable.getColumnCount(); ++i) {
            if (!firstTable.getColumnDefinition(i).isInstanceColumn()) continue;
            instanceColumns.add(i);
        }
        if (outputFormat == null || outputFormat.isEmpty() || outputFormat.equalsIgnoreCase("RowColumn")) {
            outputData = this.transformTableDataOutputByRowColumn(tableValues, instanceColumns);
        } else if (outputFormat.equalsIgnoreCase("ColumnRow")) {
            outputData = this.transformTableDataOutputByColumnRow(tableValues);
        } else if (outputFormat.equalsIgnoreCase("InstanceColumnRow")) {
            outputData = this.transformTableDataOutputByInstanceColumnRow(tableValues, instanceColumns);
        } else {
            throw new Exception("Invalid table output format");
        }
        response.put("values", outputData);
        return response;
    }

    private Object transformTableDataOutputByRowColumn(DciDataRow[] tableValues, List<Integer> instanceColumns) throws Exception {
        JsonArray output = new JsonArray(tableValues.length);
        for (int i = 0; i < tableValues.length; ++i) {
            Table table = (Table)tableValues[i].getValue();
            JsonObject entry = new JsonObject();
            entry.addProperty("timestamp", (Number)(tableValues[i].getTimestamp().getTime() / 1000L));
            JsonArray rows = new JsonArray(table.getRowCount());
            for (int j = 0; j < table.getRowCount(); ++j) {
                TableRow r = table.getRow(j);
                JsonObject jr = new JsonObject();
                jr.addProperty("__instance", HistoricalData.instanceKeyForRow((Table)table, (int)j, instanceColumns));
                for (int k = 0; k < table.getColumnCount(); ++k) {
                    jr.addProperty(table.getColumnName(k), r.getValue(k));
                }
                rows.add((JsonElement)jr);
            }
            entry.add("rows", (JsonElement)rows);
            output.add((JsonElement)entry);
        }
        return output;
    }

    private Object transformTableDataOutputByColumnRow(DciDataRow[] tableValues) throws Exception {
        JsonArray output = new JsonArray(tableValues.length);
        for (int i = 0; i < tableValues.length; ++i) {
            Table table = (Table)tableValues[i].getValue();
            JsonObject entry = new JsonObject();
            entry.addProperty("timestamp", (Number)(tableValues[i].getTimestamp().getTime() / 1000L));
            JsonObject columns = new JsonObject();
            for (int j = 0; j < table.getColumnCount(); ++j) {
                TableColumnDefinition c = table.getColumnDefinition(j);
                JsonArray jc = new JsonArray(table.getRowCount());
                for (int k = 0; k < table.getRowCount(); ++k) {
                    jc.add(table.getCellValue(k, j));
                }
                columns.add(c.getName(), (JsonElement)jc);
            }
            entry.add("columns", (JsonElement)columns);
            output.add((JsonElement)entry);
        }
        return output;
    }

    private Object transformTableDataOutputByInstanceColumnRow(DciDataRow[] tableValues, List<Integer> instanceColumns) throws Exception {
        if (instanceColumns.isEmpty()) {
            throw new Exception("No instance columns in requested table");
        }
        HashMap transformedData = new HashMap();
        for (int i = 0; i < tableValues.length; ++i) {
            long timestamp = tableValues[i].getTimestamp().getTime() / 1000L;
            Table table = (Table)tableValues[i].getValue();
            for (int j = 0; j < table.getRowCount(); ++j) {
                String instanceKey = HistoricalData.instanceKeyForRow((Table)table, (int)j, instanceColumns);
                if (transformedData.get(instanceKey) == null) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("__instance", instanceKey);
                    transformedData.put(instanceKey, data);
                }
                for (TableColumnDefinition column : table.getColumns()) {
                    HashMap<String, Object> cell = new HashMap<String, Object>();
                    cell.put("value", table.getCellValue(j, table.getColumnIndex(column.getName())));
                    cell.put("timestamp", timestamp);
                    ArrayList cells = (ArrayList)((Map)transformedData.get(instanceKey)).get(column.getName());
                    if (cells == null) {
                        cells = new ArrayList();
                        ((Map)transformedData.get(instanceKey)).put(column.getName(), cells);
                    }
                    cells.add(cell);
                }
            }
        }
        ArrayList dataList = new ArrayList();
        for (Object _dataItem : transformedData.values()) {
            dataList.add(_dataItem);
        }
        return dataList;
    }

    private static String instanceKeyForRow(Table table, int row, List<Integer> instanceColumns) {
        if (instanceColumns.isEmpty()) {
            return null;
        }
        StringBuilder instanceKey = new StringBuilder();
        for (Integer column : instanceColumns) {
            if (instanceKey.length() > 0) {
                instanceKey.append('-');
            }
            instanceKey.append(table.getCellValue(row, column.intValue()));
        }
        return instanceKey.toString();
    }

    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        String dciQuery = query.get("dciList");
        String[] requestPairs = dciQuery.split(";");
        if (requestPairs == null) {
            throw new NXCException(14);
        }
        HashMap<Long, DciData> dciData = new HashMap<Long, DciData>();
        for (int i = 0; i < requestPairs.length; ++i) {
            long from;
            Date now;
            String[] dciPairs = requestPairs[i].split(",");
            if (dciPairs == null) {
                throw new NXCException(14);
            }
            String dciId = dciPairs[0];
            String nodeId = dciPairs[1];
            String timeFrom = dciPairs[2];
            String timeTo = dciPairs[3];
            String timeInterval = dciPairs[4];
            String timeUnit = dciPairs[5];
            if (dciId == null || nodeId == null || !(session.findObjectById(HistoricalData.parseLong((String)nodeId, (long)0L)) instanceof DataCollectionTarget)) {
                throw new NXCException(7);
            }
            DciData collectedData = null;
            if (!timeFrom.equals("0") || !timeTo.equals("0")) {
                collectedData = session.getCollectedData(HistoricalData.parseLong((String)nodeId, (long)0L), HistoricalData.parseLong((String)dciId, (long)0L), new Date(HistoricalData.parseLong((String)timeFrom, (long)0L) * 1000L), new Date(HistoricalData.parseLong((String)timeTo, (long)(System.currentTimeMillis() / 1000L)) * 1000L), 0, HistoricalDataType.PROCESSED);
            } else if (!timeInterval.equals("0")) {
                now = new Date();
                from = HistoricalData.parseInt((String)timeUnit, (int)0) == TimeUnit.HOUR.getValue() ? now.getTime() - HistoricalData.parseLong((String)timeInterval, (long)0L) * 3600000L : (HistoricalData.parseInt((String)timeUnit, (int)0) == TimeUnit.DAY.getValue() ? now.getTime() - HistoricalData.parseLong((String)timeInterval, (long)0L) * 3600000L * 24L : now.getTime() - HistoricalData.parseLong((String)timeInterval, (long)0L) * 60000L);
                collectedData = session.getCollectedData((long)HistoricalData.parseInt((String)nodeId, (int)0), (long)HistoricalData.parseInt((String)dciId, (int)0), new Date(from), new Date(), 0, HistoricalDataType.PROCESSED);
            } else {
                now = new Date();
                from = now.getTime() - 3600000L;
                collectedData = session.getCollectedData((long)HistoricalData.parseInt((String)nodeId, (int)0), (long)HistoricalData.parseInt((String)dciId, (int)0), new Date(from), now, 0, HistoricalDataType.PROCESSED);
            }
            dciData.put(Long.valueOf(HistoricalData.parseInt((String)dciId, (int)0)), collectedData);
        }
        return new ResponseContainer("values", dciData);
    }
}

